/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel;

import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.RmiDispatcher;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.RmiProxy;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.UnknownMethodException;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ContextUI;
import java.io.IOException;

public class ContextProxy
extends RmiProxy {
    private boolean sdhPreferred = false;
    private boolean coupledTxRx = false;
    private boolean thruModeEnabled = false;
    private boolean opticalInterface = false;
    private boolean oldSonetNumbering = false;
    private boolean sdhStyleSonet = false;
    private boolean payloadIndicatorVisible = true;
    private static final short GET_SONET_SDH_PREFERENCE = 0;
    private static final short GET_TX_RX_COUPLING_STATE = 1;
    private static final short GET_THRU_MODE_STATE = 2;
    private static final short GET_ELAPSED_TIME = 3;
    private static final short START_ELAPSED_TIME = 4;
    private static final short STOP_ELAPSED_TIME = 5;
    private static final short RESET_ELAPSED_TIME = 6;
    private static final short GET_CV_NOTATION_PREFERENCE = 7;
    private static final short GET_STS1_NUMBERING_PREFERENCE = 8;
    private static final short GET_PAYLOAD_INDICATOR_VISIBLE = 9;
    private static final short NOTIFY_ELAPSED_TIME_CHANGE = 10;
    private ContextUI ui = null;

    protected ContextProxy(RmiDispatcher d) {
        super(d);
    }

    public void initialise() {
        this.callRemoteMethod(this, (short)0);
        this.callRemoteMethod(this, (short)2);
        this.callRemoteMethod(this, (short)1);
        this.callRemoteMethod(this, (short)8);
        this.callRemoteMethod(this, (short)7);
        this.callRemoteMethod(this, (short)9);
    }

    public boolean isCoupledTxRx() {
        return this.coupledTxRx;
    }

    public boolean isOldSonetNumbering() {
        return this.oldSonetNumbering;
    }

    public boolean isOpticalInterface() {
        return this.opticalInterface;
    }

    public boolean isPayloadIndicatorVisible() {
        return this.payloadIndicatorVisible;
    }

    public boolean isSdhPreferred() {
        return this.sdhPreferred;
    }

    public boolean isSdhStyleSonet() {
        return this.sdhStyleSonet;
    }

    public boolean isThruModeEnabled() {
        return this.thruModeEnabled;
    }

    public void receive(PrimitiveTypesReader r) throws IOException, UnknownMethodException {
        short methodId = r.readShort();
        switch (methodId) {
            case 0: {
                byte b = r.readByte();
                this.sdhPreferred = b != 0;
                break;
            }
            case 8: {
                byte b = r.readByte();
                this.oldSonetNumbering = b != 0;
                break;
            }
            case 7: {
                byte b = r.readByte();
                this.sdhStyleSonet = b != 0;
                break;
            }
            case 2: {
                byte b = r.readByte();
                this.thruModeEnabled = b != 0;
                break;
            }
            case 1: {
                byte b = r.readByte();
                this.coupledTxRx = b != 0;
                break;
            }
            case 3: 
            case 10: {
                String s = r.readString();
                this.ui.setElapsedTime(s);
                break;
            }
            case 9: {
                byte b = r.readByte();
                this.payloadIndicatorVisible = b != 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new UnknownMethodException(methodId);
            }
        }
    }

    public void resetElapsedTime() {
        this.callRemoteMethod(this, (short)6);
        this.callRemoteMethod(this, (short)3);
    }

    public void setOpticalInterface(boolean o) {
        this.opticalInterface = o;
    }

    public void setUI(ContextUI i) {
        this.ui = i;
    }

    public void startElapsedTime() {
        this.callRemoteMethod(this, (short)4);
    }

    public void stopElapsedTime() {
        this.callRemoteMethod(this, (short)5);
    }

    public String toString() {
        return "ContextProxy";
    }
}

