/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel;

import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.RmiDispatcher;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.RmiProxy;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.UnknownMethodException;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.SignalDiscoveryUI;
import java.io.IOException;

public class SignalDiscoveryProxy
extends RmiProxy {
    private static final short SUSPEND = 0;
    private static final short NOTIFY_PORT = 1;
    private static final short NOTIFY_PERCENTAGE = 2;
    private SignalDiscoveryUI ui = null;

    protected SignalDiscoveryProxy(RmiDispatcher d) {
        super(d);
    }

    public void receive(PrimitiveTypesReader r) throws IOException, UnknownMethodException {
        short methodId = r.readShort();
        switch (methodId) {
            case 1: {
                String name = r.readString();
                int rateKhz = r.readInt();
                byte isValid = r.readByte();
                byte isOptical = r.readByte();
                this.ui.addPort(name, rateKhz, isOptical != 0, isValid != 0);
                break;
            }
            case 2: {
                byte percentage = r.readByte();
                this.ui.setPercentageComplete(percentage);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new UnknownMethodException(methodId);
            }
        }
    }

    public void setUI(SignalDiscoveryUI i) {
        this.ui = i;
    }

    public void start() {
        this.ui.start();
    }

    public void suspend() {
        this.callRemoteMethod(this, (short)0);
    }

    public String toString() {
        return "SignalDiscoveryProxy";
    }
}

