/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel;

import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.RmiDispatcher;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.RmiProxy;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.UnknownMethodException;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.AnalyserProxy;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.AnalyserUI;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.StructureScopeUI;
import java.io.IOException;

public class StructureScopeProxy
extends RmiProxy {
    private static final short SUSPEND = 0;
    private static final short RESET_HISTORY = 1;
    private static final short SET_DATA_CAPTURE_SOURCE = 2;
    private static final short GET_ROOT_ANALYSER = 3;
    private static final short GET_OPTICAL_POWER = 4;
    private static final short NOTIFY_OPTICAL_POWER_CHANGE = 5;
    private static final short NOTIFY_SCAN_PERCENTAGE_CHANGE = 6;
    private StructureScopeUI ui = null;

    protected StructureScopeProxy(RmiDispatcher d) {
        super(d);
    }

    public void addAnalyserUI(AnalyserUI v, AnalyserUI parent, int indexInParent) {
        this.ui.addAnalyserUI(v, parent, indexInParent);
    }

    public AnalyserProxy createAnalyser(short id, AnalyserProxy parent, int indexInParent) {
        if (id != 0) {
            AnalyserProxy a = new AnalyserProxy(this.dispatcher(), this, id, parent, indexInParent);
            if (this.dispatcher().registerReceiver(a, id)) {
                if (parent != null) {
                    parent.addChild(a, indexInParent);
                }
                a.initialise();
                return a;
            }
            a.cleanup();
        }
        return null;
    }

    public AnalyserUI createAnalyserUI(AnalyserProxy analyser) {
        return this.ui.createAnalyserUI(analyser);
    }

    public void receive(PrimitiveTypesReader r) throws IOException, UnknownMethodException {
        short methodId = r.readShort();
        switch (methodId) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                short objectId = r.readShort();
                this.createAnalyser(objectId, null, -1);
                break;
            }
            case 4: 
            case 5: {
                String power = r.readString();
                this.ui.setOpticalPower(power);
                break;
            }
            case 6: {
                byte percent = r.readByte();
                this.ui.setScanPercentage(percent);
                break;
            }
            default: {
                throw new UnknownMethodException(methodId);
            }
        }
    }

    public void requestRootAnalyser() {
        this.callRemoteMethod(this, (short)3);
    }

    public void resetHistory() {
        this.callRemoteMethod(this, (short)1);
    }

    public void setUI(StructureScopeUI i) {
        this.ui = i;
    }

    public void start() {
        this.callRemoteMethod(this, (short)4);
        this.callRemoteMethod(this, (short)3);
        this.ui.start();
    }

    public String toString() {
        return "StructureScopeProxy";
    }
}

