/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel;

import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.RmiDispatcher;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.RmiProxy;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.UnknownMethodException;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.TraceMessage;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.TraceMessageSearcherUI;
import java.io.IOException;

public class TraceMessageSearcherProxy
extends RmiProxy {
    private static final short SET_SEARCH_CRITERION = 0;
    private static final short SET_PAGE_SIZE = 1;
    private static final short START_SEARCH = 2;
    private static final short ABORT_SEARCH = 3;
    private static final short NOTIFY_PAGE = 4;
    private static final short NOTIFY_PERCENTAGE = 5;
    private TraceMessageSearcherUI ui = null;

    protected TraceMessageSearcherProxy(RmiDispatcher d) {
        super(d);
    }

    public void abortSearch(int analyserId) {
        try {
            ApplicationGenericMetaData m = this.beginRemoteCall(this, (short)3);
            if (m != null) {
                m.getPrimitiveTypesWriter().write(analyserId);
                this.concludeRemoteCall(m);
            }
        }
        catch (IOException iOException) {}
    }

    public synchronized void receive(PrimitiveTypesReader r) throws IOException, UnknownMethodException {
        short methodId = r.readShort();
        switch (methodId) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                int pageNum = r.readInt();
                int numMessages = r.readInt();
                byte moreToFollow = r.readByte();
                TraceMessage[] info = new TraceMessage[numMessages];
                int i = 0;
                while (i < numMessages) {
                    int channel = r.readInt();
                    byte label = r.readByte();
                    String message = r.readString();
                    info[i] = new TraceMessage(channel, label, message);
                    ++i;
                }
                this.ui.setTraceMessagePage(pageNum, info, moreToFollow != 0);
                break;
            }
            case 5: {
                byte percentage = r.readByte();
                if (percentage < 100) break;
                this.ui.notifySearchComplete();
                break;
            }
            default: {
                throw new UnknownMethodException(methodId);
            }
        }
    }

    public void setPageSize(int p) {
        try {
            ApplicationGenericMetaData m = this.beginRemoteCall(this, (short)1);
            if (m != null) {
                m.getPrimitiveTypesWriter().write(p);
                this.concludeRemoteCall(m);
            }
        }
        catch (IOException iOException) {}
    }

    public void setSearchCriterion(String s) {
        try {
            ApplicationGenericMetaData m = this.beginRemoteCall(this, (short)0);
            if (m != null) {
                m.getPrimitiveTypesWriter().write(s);
                this.concludeRemoteCall(m);
            }
        }
        catch (IOException iOException) {}
    }

    public void setUI(TraceMessageSearcherUI i) {
        this.ui = i;
    }

    public void startSearch(int analyserId, int page) {
        try {
            ApplicationGenericMetaData m = this.beginRemoteCall(this, (short)2);
            if (m != null) {
                m.getPrimitiveTypesWriter().write(analyserId);
                m.getPrimitiveTypesWriter().write(page);
                this.concludeRemoteCall(m);
            }
        }
        catch (IOException iOException) {}
    }

    public String toString() {
        return "TraceMessageSearcherProxy";
    }
}

