/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.util;

public class EventThrottle {
    private int maxEventsPerSecond = 0;
    private int currentEventCount = 0;
    private Listener listener = null;

    EventThrottle(Listener l, int eventsPerSecond) {
        this.listener = l;
        this.maxEventsPerSecond = eventsPerSecond;
    }

    void notifyTick() {
        if (this.currentEventCount > this.maxEventsPerSecond) {
            this.sendEvent();
        }
        this.currentEventCount = 0;
    }

    public void receiveEvent() {
        ++this.currentEventCount;
        if (this.currentEventCount <= this.maxEventsPerSecond) {
            this.sendEvent();
        }
    }

    private void sendEvent() {
        if (this.listener != null) {
            this.listener.notifyEvent(this);
        }
    }

    public static interface Listener {
        public void notifyEvent(EventThrottle var1);
    }
}

