/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.util;

import com.agilent.tntd.eclipse.common.util.SingletonRegistry;
import com.agilent.tntd.eclipse.thinclient.signalwizard.util.EventThrottle;
import com.agilent.tntd.eclipse.thinclient.signalwizard.util.Ticker;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;

public class ThrottleManager {
    private ArrayList clients = new ArrayList();
    private Ticker timer = null;
    private static ThrottleManager instance = null;

    private ThrottleManager() {
    }

    private void cleanup() {
        if (this.timer != null) {
            this.timer.pleaseStop();
        }
        if (instance != null) {
            SingletonRegistry.instance().remove((Object)instance);
        }
        this.timer = null;
        instance = null;
    }

    public static EventThrottle createThrottle(EventThrottle.Listener l, int maxEventsPerSecond) {
        EventThrottle e = new EventThrottle(l, maxEventsPerSecond);
        ArrayList arrayList = ThrottleManager.instance().clients;
        synchronized (arrayList) {
            ThrottleManager.instance().clients.add((Object)e);
        }
        return e;
    }

    private static ThrottleManager instance() {
        if (instance == null) {
            instance = new ThrottleManager();
            SingletonRegistry.instance().add((Object)instance);
            instance.startThread();
        }
        return instance;
    }

    public static void removeThrottle(EventThrottle t) {
        ArrayList arrayList = ThrottleManager.instance().clients;
        synchronized (arrayList) {
            ThrottleManager.instance().clients.remove((Object)t);
            if (ThrottleManager.instance().clients.size() == 0) {
                ThrottleManager.instance().cleanup();
            }
        }
    }

    private void startThread() {
        if (this.timer == null) {
            this.timer = new Ticker(1000, new Ticker.Listener(this){
                /* synthetic */ ThrottleManager this$0;

                public void notifyTick(Ticker t) {
                    ThrottleManager.access$tick(this.this$0);
                }
                {
                    this.this$0 = this$0;
                }
            });
            this.timer.setPriority(Thread.currentThread().getPriority() - 1);
        }
        this.timer.start();
    }

    private void tick() {
        ArrayList arrayList = this.clients;
        synchronized (arrayList) {
            Iterator i = this.clients.iterator();
            while (i.hasNext()) {
                ((EventThrottle)i.next()).notifyTick();
            }
        }
    }

    static void access$tick(ThrottleManager throttleManager) {
        throttleManager.tick();
    }
}

