/*
 * Decompiled with CFR 0.152.
 */
package espial.net.cache;

import espial.net.cache.CacheEntry;
import espial.net.cache.CacheManager;
import java.io.InputStream;
import java.net.URL;

public abstract class CacheManagerBase
implements CacheManager {
    protected CacheManager m_secondary;

    public abstract CacheEntry getNewCacheEntry();

    public abstract boolean register(CacheEntry var1);

    public abstract void ensureSpace(int var1);

    public abstract void setCacheSize(int var1);

    public final void decache(URL uRL) {
        CacheEntry cacheEntry = this.locate(uRL);
        if (cacheEntry != null) {
            this.reject(cacheEntry);
        }
        if (this.m_secondary != null) {
            this.m_secondary.decache(uRL);
        }
    }

    public synchronized void setSecondaryCache(CacheManager cacheManager) {
        this.m_secondary = cacheManager;
    }

    public synchronized void reject(CacheEntry cacheEntry) {
        this.free(cacheEntry);
    }

    public final synchronized void release(CacheEntry cacheEntry) {
        this.a(cacheEntry);
        this.free(cacheEntry);
    }

    protected abstract void free(CacheEntry var1);

    private final void a(CacheEntry cacheEntry) {
        if (!cacheEntry.isValid()) {
            return;
        }
        if (this.m_secondary != null) {
            CacheEntry cacheEntry2 = this.m_secondary.getNewCacheEntry();
            InputStream inputStream = cacheEntry2.reset(cacheEntry.getKey(), cacheEntry.getCreation(), cacheEntry.getInputStream(), true);
            byte[] byArray = new byte[4192];
            int n2 = 0;
            try {
                while ((n2 = inputStream.read(byArray)) == byArray.length) {
                }
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_secondary.register(cacheEntry2);
        }
    }

    protected abstract CacheEntry locateImpl(URL var1);

    public final CacheEntry locate(URL uRL) {
        CacheEntry cacheEntry = this.locateImpl(uRL);
        if (cacheEntry == null && this.m_secondary != null) {
            return this.m_secondary.locate(uRL);
        }
        return cacheEntry;
    }
}

