/*
 * Decompiled with CFR 0.152.
 */
package espial.net.crypto.cipher;

import espial.net.crypto.cipher.BlockCipher;
import espial.net.crypto.cipher.Cipher;

public class CbcBlockCipher
extends BlockCipher {
    private byte[] a;
    private byte[] b;
    protected byte[] iv;
    protected BlockCipher blockCipher;

    public static int addPadding(byte[] byArray, int n2, int n3, int n4) {
        int n5 = n3 + 1;
        if (n5 % n4 != 0) {
            n5 += n4 - 1;
            n5 -= n5 % n4;
        }
        int n6 = n5 - n3;
        if (byArray.length < n5 + n2) {
            throw new IllegalArgumentException("Insufficient space for padding");
        }
        int n7 = 0;
        n2 += n3;
        while (n7 < n6) {
            byArray[n2++] = (byte)(n6 - 1);
            ++n7;
        }
        return n5;
    }

    public static int removePadding(byte[] byArray, int n2, int n3, int n4) {
        int n5 = byArray[n2 + n3 - 1] & 0xFF;
        if (++n5 <= n4) {
            return n3 - n5;
        }
        return n3;
    }

    public int encrypt(byte[] byArray, int n2, int n3) {
        int n4 = CbcBlockCipher.addPadding(byArray, n2, n3, this.blockSize);
        int n5 = 0;
        while (n5 < n4) {
            this.encrypt(byArray, n2, byArray, n2);
            n5 += this.blockSize;
            n2 += this.blockSize;
        }
        return n4;
    }

    public int decrypt(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        int n5 = 0;
        while (n5 < n3) {
            this.decrypt(byArray, n4, byArray, n4);
            n5 += this.blockSize;
            n4 += this.blockSize;
        }
        return CbcBlockCipher.removePadding(byArray, n2, n3, this.blockSize);
    }

    public void encrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        Cipher.xorBlock(byArray, n2, this.iv, 0, this.b, 0, this.blockSize);
        this.blockCipher.encrypt(this.b, 0, byArray2, n3);
        Cipher.copyBlock(byArray2, n3, this.iv, 0, this.blockSize);
    }

    public void decrypt(byte[] byArray, int n2, byte[] byArray2, int n3) {
        this.blockCipher.decrypt(byArray, n2, this.b, 0);
        Cipher.xorBlock(this.b, 0, this.iv, 0, this.a, 0, this.blockSize);
        Cipher.copyBlock(byArray, n2, this.iv, 0, this.blockSize);
        Cipher.copyBlock(this.a, 0, byArray2, n3, this.blockSize);
    }

    public void setIv(byte[] byArray) {
        Cipher.copyBlock(byArray, 0, this.iv, 0, this.blockSize);
    }

    public void setKey(byte[] byArray) {
        this.blockCipher.setKey(byArray);
    }

    public CbcBlockCipher(BlockCipher blockCipher) {
        super(blockCipher.keySize(), blockCipher.blockSize());
        this.blockCipher = blockCipher;
        this.iv = new byte[this.blockSize];
        Cipher.zeroBlock(this.iv, 0, this.blockSize);
        this.b = new byte[this.blockSize];
        this.a = new byte[this.blockSize];
    }
}

