/*
 * Decompiled with CFR 0.152.
 */
package espial.net.util;

import espial.net.util.MD5;
import espial.net.util.SHA;
import java.io.IOException;

public abstract class MessageDigest {
    private String c;
    private byte[] a;
    private static boolean b;

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    protected abstract int engineDigest(byte[] var1, int var2, int var3);

    protected abstract void engineReset();

    protected abstract byte[] engineDigest();

    protected abstract void engineUpdate(byte[] var1, int var2, int var3);

    protected abstract void engineUpdate(byte var1);

    public final String getAlgorithm() {
        return this.c;
    }

    public void reset() {
        this.engineReset();
        this.a = null;
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int digest(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new IOException("No output buffer given");
        }
        if (byArray.length - n2 < n3) {
            throw new IOException("Output buffer too small for specified offset and length");
        }
        int n4 = this.engineDigest(byArray, n2, n3);
        return n4;
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    public byte[] digest() {
        this.a = this.engineDigest();
        return this.a;
    }

    public void update(byte[] byArray) {
        this.engineUpdate(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.engineUpdate(byArray, n2, n3);
    }

    public void update(byte by) {
        this.engineUpdate(by);
    }

    public static MessageDigest getInstance(String string) throws IOException {
        if (string.equals("SHA") || string.equals("SHA-1")) {
            return new SHA();
        }
        if (string.equals("MD5")) {
            return new MD5();
        }
        throw new IOException(string + " algorithm is not supported");
    }

    protected MessageDigest(String string) {
        this.c = string;
    }
}

