/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.jitter;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindow;
import com.agilent.tntd.eclipse.viewlayer.containers.window.ModalWindowHandler;
import java.io.IOException;

public class JitterAppApplicationInterface
implements CcConnectedComponent,
MaskedIntegerDataReceiver,
ApplicationGenericDataReceiver {
    private transient String databaseVariable = null;
    private transient ApplicationObject theApplicationObject = null;
    private transient ApplicationObject appRunningApplicationObject = null;
    private static final byte startAppMethod = 0;
    private static final byte stopAppMethod = 1;
    private static final byte appStartedScpi = 2;
    private static final byte methodPass = 1;
    private static final byte methodFail = 0;
    private transient boolean applicationRunning = false;
    private transient MaskedIntegerValue lastValue = null;
    private transient ModalWindowHandler windowHandler = null;
    private boolean scpiStartingApp = false;

    protected JitterAppApplicationInterface(String string) {
        this.databaseVariable = string;
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.unregister();
        } else if (applicationObject.getName() == "STEST_APPLICATION_RUNNING") {
            this.appRunningApplicationObject = applicationObject;
        } else {
            this.theApplicationObject = applicationObject;
        }
    }

    private ApplicationGenericMetaData createMetaData(byte by) {
        ApplicationGenericMetaData applicationGenericMetaData = new ApplicationGenericMetaData();
        PrimitiveTypesWriter primitiveTypesWriter = applicationGenericMetaData.getPrimitiveTypesWriter();
        try {
            primitiveTypesWriter.write(by);
        }
        catch (IOException iOException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " createMetaData() IOException");
        }
        applicationGenericMetaData.completedMetaDataInitialisation();
        return applicationGenericMetaData;
    }

    public void finishInitialise() {
        ApplicationManager.instance().request("ISS", 0, this.databaseVariable, (ApplicationObjectObserver)this);
    }

    protected boolean guiTakeControl() {
        return this.appRunningApplicationObject.change((ApplicationData)this.lastValue);
    }

    public void receiveApplicationGenericData(ApplicationGenericData applicationGenericData, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theApplicationObject) {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            try {
                byte by = primitiveTypesReader.readByte();
                byte by2 = primitiveTypesReader.readByte();
                if (by == 0) {
                    if (by2 != 1) {
                        this.windowHandler.removeModalWindow();
                    }
                } else if (by == 1) {
                    if (by2 != 1) {
                        EventLog.instance().log(String.valueOf(this.toString()) + "receiveApplicationGenericData stopApp() status bad");
                    }
                } else if (by == 2) {
                    if (by2 != 1) {
                        EventLog.instance().log(String.valueOf(this.toString()) + "receiveApplicationGenericData appStartedScpi() status bad");
                    } else {
                        this.scpiStartingApp = true;
                        this.startAppScpi();
                    }
                } else {
                    EventLog.instance().log(String.valueOf(this.toString()) + "receiveApplicationGenericData method index invalid");
                }
            }
            catch (IOException iOException) {
                EventLog.instance().log(String.valueOf(this.toString()) + " receiveApplicationGenericData() IOException");
            }
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.appRunningApplicationObject) {
            this.lastValue = maskedIntegerValue;
            this.setAppRunningFlag(maskedIntegerValue.getValue() != 0);
        }
    }

    public boolean scpiStartingApp() {
        return this.scpiStartingApp;
    }

    private void sendQuery(ApplicationGenericMetaData applicationGenericMetaData) {
        this.theApplicationObject.asyncQuery((ApplicationMetaData)applicationGenericMetaData, (ApplicationObjectObserver)this);
    }

    protected void setAppRunningFlag(boolean bl) {
        if (bl) {
            this.applicationRunning = true;
        } else if (this.applicationRunning) {
            this.applicationRunning = false;
            this.scpiStartingApp = false;
            this.windowHandler.removeModalWindow();
            return;
        }
    }

    public void setWindow(EclWindow eclWindow) {
        this.windowHandler = new ModalWindowHandler();
        this.windowHandler.setWindow((InternalWindow)eclWindow);
        ApplicationManager.instance().request("ISS", 0, "STEST_APPLICATION_RUNNING", (ApplicationObjectObserver)this);
    }

    public void startAppGui() {
        this.scpiStartingApp = false;
        if (!this.guiTakeControl()) {
            this.windowHandler.removeModalWindow();
            return;
        }
        this.sendQuery(this.createMetaData((byte)0));
    }

    protected void startAppScpi() {
        EventLog.instance().log(String.valueOf(this.toString()) + "startAppScpi() not implemented");
    }

    public void stopAppGui() {
        this.scpiStartingApp = false;
        this.sendQuery(this.createMetaData((byte)1));
    }

    public void trapTransientError(boolean bl) {
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister((ApplicationObjectObserver)this);
            this.theApplicationObject = null;
        }
        if (this.appRunningApplicationObject != null) {
            this.appRunningApplicationObject.unregister((ApplicationObjectObserver)this);
            this.appRunningApplicationObject = null;
        }
    }

    public void unregisterSmartTest() {
        if (this.appRunningApplicationObject != null) {
            this.appRunningApplicationObject.unregister((ApplicationObjectObserver)this);
            this.appRunningApplicationObject = null;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        if (applicationData != null) {
            try {
                applicationData.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)applicationObject);
            }
            catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
                EventLog.instance().log(String.valueOf(this.toString()) + "doesn't implement the right interface to receive " + applicationData.toString() + " from " + applicationObject.toString());
            }
        }
    }
}

