/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_setup;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.Tiler;
import com.agilent.tntd.lynx.txrx.mixedbackground.DBconnection;
import com.agilent.tntd.lynx.txrx.mixedbackground.TelecomsHelper;
import java.io.IOException;

public class VcatChanReader
extends GenericDataReader
implements MaskedIntegerDataReceiver {
    private boolean m_vcatChanValid = false;
    private int m_vcatChan = 0;
    private String m_vcatChanStr = "";
    private boolean m_vcatChanGrey = true;
    private Tiler m_patternTiler = null;
    private int m_labelLength = 14;
    private DBconnection m_signalMode = new DBconnection(this, "TX_SIGNAL_STD", 0);
    private DBconnection m_signalRate = new DBconnection(this, "TX_SIGNAL_RATE", 0);
    private DBconnection m_mapping = new DBconnection(this, "TX_MAPPING_AU", 0);
    private boolean dataReady;

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        try {
            int n;
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            this.m_vcatChanValid = primitiveTypesReader.readBoolean();
            this.m_vcatChan = primitiveTypesReader.readInt();
            this.m_vcatChanGrey = primitiveTypesReader.readBoolean();
            if (this.m_vcatChanValid) {
                TelecomsHelper telecomsHelper = new TelecomsHelper();
                TelecomsHelper.setMode(this.m_signalMode.getDBValue());
                TelecomsHelper.setRate(this.m_signalRate.getDBValue());
                n = 3;
                if (this.m_mapping.getDBValue() == 7) {
                    n = 1;
                }
                this.m_vcatChanStr = TelecomsHelper.getStartLabel(this.m_vcatChan, "", n);
            } else {
                this.m_vcatChanStr = "         ...";
            }
            int n2 = this.m_vcatChanStr.length();
            if (this.m_labelLength != n2) {
                n = 0;
                while (n < this.m_labelLength - n2) {
                    this.m_vcatChanStr = " " + this.m_vcatChanStr;
                    ++n;
                }
            }
            String string = "";
            int n3 = 0;
            while (n3 < this.m_labelLength) {
                string = String.valueOf(string) + " ";
                ++n3;
            }
            this.m_vcatChanStr = String.valueOf(this.m_vcatChanStr) + "," + string + "," + string + "," + string + "," + string + ",,,,,";
            this.dataReady = true;
        }
        catch (IOException iOException) {
            this.dataReady = false;
        }
        return true;
    }

    public boolean isDataReady() {
        return this.dataReady;
    }

    public ApplicationData modifyDataToChange(ApplicationData applicationData) {
        ApplicationData applicationData2 = applicationData;
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            this.m_vcatChanValid = true;
            simpleTypesWriter.write(this.m_vcatChanValid);
            String string = ((KnownLengthStringValue)applicationData).getValue();
            if (string == "         ...") {
                simpleTypesWriter.write(0);
            } else {
                Integer n = new Integer(string);
                simpleTypesWriter.write(Integer.parseInt(string));
            }
            simpleTypesWriter.write(this.m_vcatChanGrey);
            applicationData2 = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
        }
        catch (IOException iOException) {
            EventLog.instance().log("Could not read the meta data from this ecldataentry, or write the data to send to the server.");
        }
        catch (ClassCastException classCastException) {
            EventLog.instance().log("OvSeqFocusBytesReader - unexpected application data type was received! ");
        }
        return applicationData2;
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = false;
        GreyPropertyAccessor greyPropertyAccessor = (GreyPropertyAccessor)propertyAccessor;
        TextPropertyAccessor textPropertyAccessor = (TextPropertyAccessor)propertyAccessor;
        if (this.dataReady) {
            bl2 = greyPropertyAccessor.setGreyProperty(this.m_vcatChanGrey);
            bl2 |= textPropertyAccessor.setTextProperty(this.m_vcatChanStr);
        }
        propertyAccessor.repaint();
        return bl2;
    }
}

