/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.IndexPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.MaskedIntegerPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.CompositeReaderSupport;
import com.agilent.tntd.lynx.overhead_usercode.MonLcasTraceSinkData;
import com.agilent.tntd.lynx.txrx.mixedbackground.DBconnection;
import com.agilent.tntd.lynx.txrx.mixedbackground.TelecomsHelper;
import java.io.IOException;

public abstract class AMonLcasTraceSinkDataReader
extends GenericDataReader
implements MaskedIntegerDataReceiver {
    private int m_numElements;
    protected MonLcasTraceSinkData[] m_lcasTraceSinkData;
    protected MonLcasTraceSinkData[] m_prevlcasTraceSinkData;
    protected boolean m_dataReady;
    private static final int CURR_ELE_ID = 0;
    private static final int CURR_TIME_ID = 1;
    private static final int CHANNEL_ID = 2;
    private static final int CURR_SQI_ID = 3;
    private static final int CURRCTRLCOMBO_ID = 4;
    private static final int m_componentsPerObject = 10;
    protected boolean[] m_repaintRequired;
    protected CompositeReaderSupport m_support;
    protected DBconnection signalMode = null;
    protected DBconnection signalRate = null;
    protected DBconnection signalMapping = null;
    protected DBconnection signalMappingTu = null;
    protected int m_nChannelSize = 0;

    public AMonLcasTraceSinkDataReader(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.m_numElements = n;
        this.m_lcasTraceSinkData = new MonLcasTraceSinkData[this.m_numElements];
        this.m_prevlcasTraceSinkData = new MonLcasTraceSinkData[this.m_numElements];
        int n2 = 0;
        while (n2 < this.m_lcasTraceSinkData.length) {
            this.m_lcasTraceSinkData[n2] = new MonLcasTraceSinkData();
            this.m_prevlcasTraceSinkData[n2] = new MonLcasTraceSinkData();
            ++n2;
        }
        this.m_repaintRequired = new boolean[this.m_numElements];
        this.m_support = new CompositeReaderSupport(this.m_numElements);
    }

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        TelecomsHelper.setMode(this.signalMode.getDBValue());
        TelecomsHelper.setRate(this.signalRate.getDBValue());
        this.m_nChannelSize = 1;
        if (this.signalMappingTu.getDBValue() == 0) {
            if (this.signalMapping.getDBValue() == 6) {
                this.m_nChannelSize = 3;
            }
        } else {
            switch (this.signalMappingTu.getDBValue()) {
                case 1: {
                    this.m_nChannelSize = 2;
                    break;
                }
                case 2: {
                    this.m_nChannelSize = 4;
                    break;
                }
                default: {
                    this.m_nChannelSize = 3;
                }
            }
        }
        try {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            this.m_support.deserialize(primitiveTypesReader, this.m_lcasTraceSinkData, this.m_prevlcasTraceSinkData, this.m_repaintRequired);
            this.m_dataReady = true;
        }
        catch (IOException iOException) {
            this.m_dataReady = false;
        }
        return true;
    }

    private String getHistory(int n) {
        return ",  ,  ,  ,  ";
    }

    private int getNumElements() {
        return this.m_numElements;
    }

    public ApplicationData modifyDataToChange(ApplicationData applicationData) {
        ApplicationData applicationData2 = applicationData;
        return applicationData2;
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
    }

    private boolean setAsciiTextProperty(int n, int n2, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        String string = " ";
        if (!(propertyAccessor instanceof TextPropertyAccessor)) {
            return true;
        }
        MonLcasTraceSinkData monLcasTraceSinkData = this.m_lcasTraceSinkData[n];
        switch (n2) {
            case 0: {
                string = monLcasTraceSinkData.InContext() == 1 ? Integer.toString(monLcasTraceSinkData.getCurrElement()) : "...";
                bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 1: {
                string = monLcasTraceSinkData.InContext() == 1 ? monLcasTraceSinkData.getCurrTime() : "...";
                bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 2: {
                short s;
                string = monLcasTraceSinkData.InContext() == 1 ? ((s = monLcasTraceSinkData.getLowOrderVCATEnabled()) == 1 ? "[" + TelecomsHelper.getStartPosn(monLcasTraceSinkData.getChannelPos(), this.m_nChannelSize, true) + "]" : "[" + TelecomsHelper.getStartPosn(monLcasTraceSinkData.getChannelPos(), this.m_nChannelSize, false) + "]") : "...";
                bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 3: {
                string = monLcasTraceSinkData.InContext() == 1 ? Integer.toString(monLcasTraceSinkData.getCurrSqi()) : "...";
                bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
        }
        return bl;
    }

    private boolean setComboProperties(int n, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        MonLcasTraceSinkData monLcasTraceSinkData = this.m_lcasTraceSinkData[n];
        if (propertyAccessor instanceof IndexPropertyAccessor) {
            int n2 = monLcasTraceSinkData.InContext() == 1 ? 1 : 0;
            bl = ((IndexPropertyAccessor)propertyAccessor).setIndexProperty(n2);
            propertyAccessor.repaint();
        }
        return bl;
    }

    private boolean setCtrlComboProperty(int n, int n2, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        if (!(propertyAccessor instanceof MaskedIntegerPropertyAccessor)) {
            return true;
        }
        MonLcasTraceSinkData monLcasTraceSinkData = this.m_lcasTraceSinkData[n];
        switch (n2) {
            case 4: {
                bl = ((MaskedIntegerPropertyAccessor)propertyAccessor).setMaskedIntegerValue(monLcasTraceSinkData.getCurrCtrlCombo());
                break;
            }
        }
        return bl;
    }

    private boolean setGreyingProperty(int n, int n2, PropertyAccessor propertyAccessor) {
        boolean bl = true;
        MonLcasTraceSinkData cfr_ignored_0 = this.m_lcasTraceSinkData[n];
        if (propertyAccessor instanceof GreyPropertyAccessor) {
            bl = ((GreyPropertyAccessor)propertyAccessor).setGreyProperty(false);
        }
        return bl;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = this.m_dataReady;
        int n2 = n / 10;
        if (this.m_dataReady) {
            int n3 = n % 10;
            switch (n3) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    bl2 = this.setAsciiTextProperty(n2, n3, propertyAccessor) && this.setGreyingProperty(n2, n3, propertyAccessor);
                    propertyAccessor.repaint();
                    break;
                }
                case 4: {
                    bl2 = this.setCtrlComboProperty(n2, n3, propertyAccessor) && this.setGreyingProperty(n2, n3, propertyAccessor);
                    propertyAccessor.repaint();
                    break;
                }
            }
        }
        return bl2;
    }

    private void writeNewAsciiByteData(int n, String string, PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        int n2 = Integer.parseInt(string, 10);
        primitiveTypesWriter.write((short)n2);
    }
}

