/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.IndexPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.MaskedIntegerPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.CcGreyableComponent;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.CompositeReaderSupport;
import com.agilent.tntd.lynx.overhead_usercode.SetupLcasSourceData;
import com.agilent.tntd.lynx.txrx.mixedbackground.DBconnection;
import com.agilent.tntd.lynx.txrx.mixedbackground.TelecomsHelper;
import java.io.IOException;

public abstract class ASetupLcasSourceDataReader
extends GenericDataReader
implements MaskedIntegerDataReceiver {
    private int m_numElements;
    protected SetupLcasSourceData[] m_lcasSourceData;
    protected SetupLcasSourceData[] m_prevlcasSourceData;
    protected boolean m_dataReady;
    private static final int CHANNEL_ID = 0;
    private static final int CURRSQI_ID = 1;
    private static final int NEWSQI_ID = 2;
    private static final int CURRCTRL_ID = 3;
    private static final int CURRCTRLCOMBO_ID = 4;
    private static final int NEWCTRL_ID = 5;
    private static final int NEWCTRLCOMBO_ID = 6;
    private static final int NEWCTRLLBL_ID = 7;
    private static final int m_componentsPerObject = 10;
    private static final int PROTO_WRITE_SQI_ENABLED = 1;
    private static final int PROTO_WRITE_CTRL_ENABLED = 2;
    private static final int PROTO_WRITE_CTRLCOMBO_ENABLED = 3;
    protected boolean[] m_repaintRequired;
    protected CompositeReaderSupport m_support;
    protected DBconnection signalMode = null;
    protected DBconnection signalRate = null;
    protected DBconnection signalMapping = null;
    protected DBconnection signalMappingTu = null;
    protected int m_nChannelSize = 0;

    public ASetupLcasSourceDataReader(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.m_numElements = n;
        this.m_lcasSourceData = new SetupLcasSourceData[this.m_numElements];
        this.m_prevlcasSourceData = new SetupLcasSourceData[this.m_numElements];
        int n2 = 0;
        while (n2 < this.m_lcasSourceData.length) {
            this.m_lcasSourceData[n2] = new SetupLcasSourceData();
            this.m_prevlcasSourceData[n2] = new SetupLcasSourceData();
            ++n2;
        }
        this.m_repaintRequired = new boolean[this.m_numElements];
        this.m_support = new CompositeReaderSupport(this.m_numElements);
    }

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        TelecomsHelper.setMode(this.signalMode.getDBValue());
        TelecomsHelper.setRate(this.signalRate.getDBValue());
        this.m_nChannelSize = 1;
        if (this.signalMappingTu.getDBValue() == 0) {
            if (this.signalMapping.getDBValue() == 6) {
                this.m_nChannelSize = 3;
            }
        } else {
            switch (this.signalMappingTu.getDBValue()) {
                case 1: {
                    this.m_nChannelSize = 2;
                    break;
                }
                case 2: {
                    this.m_nChannelSize = 4;
                    break;
                }
                default: {
                    this.m_nChannelSize = 3;
                }
            }
        }
        try {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            this.m_support.deserialize(primitiveTypesReader, this.m_lcasSourceData, this.m_prevlcasSourceData, this.m_repaintRequired);
            this.m_dataReady = true;
        }
        catch (IOException iOException) {
            this.m_dataReady = false;
        }
        return true;
    }

    private String getHistory(int n) {
        return ",  ,  ,  ,  ";
    }

    private int getNumElements() {
        return this.m_numElements;
    }

    public ApplicationData modifyDataToChange(ApplicationData applicationData) {
        ApplicationData applicationData2 = applicationData;
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            int n = this.m_support.getChangeCompositeID(applicationData);
            int n2 = n / 10;
            this.m_support.writeChangeIndex(n2, (PrimitiveTypesWriter)simpleTypesWriter);
            switch (n % 10) {
                case 2: {
                    simpleTypesWriter.write(1);
                    simpleTypesWriter.write(((KnownLengthStringValue)applicationData).getValue());
                    break;
                }
                case 5: {
                    simpleTypesWriter.write(2);
                    simpleTypesWriter.write(((KnownLengthStringValue)applicationData).getValue());
                    break;
                }
                case 6: {
                    simpleTypesWriter.write(3);
                    int n3 = ((MaskedIntegerValue)applicationData).getValue();
                    byte by = (byte)(n3 & 0xFF);
                    simpleTypesWriter.write(by);
                    break;
                }
            }
            applicationData2 = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
        }
        catch (IOException iOException) {
            EventLog.instance().log("Could not read the meta data from this ecldataentry, or write the data to send to the server.");
        }
        catch (ClassCastException classCastException) {
            EventLog.instance().log("SetupLcasSourceDataReader - unexpected application data type was received! ");
        }
        return applicationData2;
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
    }

    private boolean setAsciiTextProperty(int n, int n2, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        if (!(propertyAccessor instanceof TextPropertyAccessor)) {
            return true;
        }
        SetupLcasSourceData setupLcasSourceData = this.m_lcasSourceData[n];
        switch (n2) {
            case 0: {
                String string = setupLcasSourceData.InContext() ? "[" + TelecomsHelper.getStartPosn(setupLcasSourceData.getChannelPos(), this.m_nChannelSize, setupLcasSourceData.getLowOrderVCATEnabled()) + "]" : "...";
                bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 1: {
                String string = setupLcasSourceData.InContext() ? Integer.toString(setupLcasSourceData.getCurrSqi()) : "...";
                bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 2: {
                if (!setupLcasSourceData.InContext()) break;
                bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(setupLcasSourceData.getNewSqi());
                break;
            }
            case 3: {
                if (!setupLcasSourceData.InContext()) break;
                bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(setupLcasSourceData.getCurrCtrl());
                break;
            }
            case 5: 
            case 7: {
                if (!setupLcasSourceData.InContext()) break;
                bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(setupLcasSourceData.getNewCtrl());
                break;
            }
        }
        return bl;
    }

    private boolean setComboProperties(int n, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        SetupLcasSourceData setupLcasSourceData = this.m_lcasSourceData[n];
        if (propertyAccessor instanceof IndexPropertyAccessor) {
            int n2 = setupLcasSourceData.InContext() ? 1 : 0;
            bl = ((IndexPropertyAccessor)propertyAccessor).setIndexProperty(n2);
            propertyAccessor.repaint();
        }
        return bl;
    }

    private boolean setCtrlComboProperty(int n, int n2, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        if (!(propertyAccessor instanceof MaskedIntegerPropertyAccessor)) {
            return true;
        }
        SetupLcasSourceData setupLcasSourceData = this.m_lcasSourceData[n];
        switch (n2) {
            case 6: {
                bl = ((MaskedIntegerPropertyAccessor)propertyAccessor).setMaskedIntegerValue(setupLcasSourceData.getNewCtrlCombo());
                break;
            }
            case 4: {
                bl = ((MaskedIntegerPropertyAccessor)propertyAccessor).setMaskedIntegerValue(setupLcasSourceData.getCurrCtrlCombo());
                break;
            }
        }
        return bl;
    }

    private boolean setGreyingProperty(int n, int n2, PropertyAccessor propertyAccessor) {
        boolean bl = true;
        SetupLcasSourceData cfr_ignored_0 = this.m_lcasSourceData[n];
        if (propertyAccessor instanceof GreyPropertyAccessor) {
            bl = ((GreyPropertyAccessor)propertyAccessor).setGreyProperty(false);
        }
        if (propertyAccessor instanceof CcGreyableComponent) {
            ((CcGreyableComponent)propertyAccessor).setGreying(false, true);
        }
        return bl;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = this.m_dataReady;
        int n2 = n / 10;
        if (this.m_dataReady) {
            int n3 = n % 10;
            switch (n3) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    bl2 = this.setAsciiTextProperty(n2, n3, propertyAccessor) && this.setGreyingProperty(n2, n3, propertyAccessor);
                    propertyAccessor.repaint();
                    break;
                }
                case 4: 
                case 6: {
                    bl2 = this.setCtrlComboProperty(n2, n3, propertyAccessor) && this.setGreyingProperty(n2, n3, propertyAccessor);
                    propertyAccessor.repaint();
                    break;
                }
            }
        }
        return bl2;
    }

    private void writeNewAsciiByteData(int n, String string, PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        int n2 = Integer.parseInt(string, 10);
        primitiveTypesWriter.write((short)n2);
    }
}

