/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.AppSerializable;
import java.io.IOException;

public class MonLcasSinkData
implements AppSerializable {
    private boolean m_bInContext;
    private boolean m_bLoVCat;
    private int m_channelPos;
    private int m_nCurrSqi;
    private String m_sCurrCtrl;
    private MaskedIntegerValue m_CurrCtrlCombo;
    private String m_sActiveState;
    private MaskedIntegerValue m_ActionCombo;

    public void deserialize(PrimitiveTypesReader primitiveTypesReader) throws IOException {
        MaskedIntegerValue maskedIntegerValue;
        this.m_bInContext = primitiveTypesReader.readBoolean();
        this.m_bLoVCat = primitiveTypesReader.readBoolean();
        this.m_channelPos = primitiveTypesReader.readInt();
        this.m_nCurrSqi = primitiveTypesReader.readShort();
        this.m_sCurrCtrl = primitiveTypesReader.readString();
        byte by = primitiveTypesReader.readByte();
        primitiveTypesReader.readLong();
        primitiveTypesReader.readLong();
        this.m_CurrCtrlCombo = maskedIntegerValue = new MaskedIntegerValue((int)by, 127L, 127L);
        this.m_sActiveState = primitiveTypesReader.readString();
        by = primitiveTypesReader.readByte();
        this.m_ActionCombo = maskedIntegerValue = new MaskedIntegerValue((int)by, 7L, 7L);
        if (!this.m_bInContext) {
            this.m_bLoVCat = false;
            this.m_channelPos = 0;
            this.m_nCurrSqi = 0;
            this.m_sCurrCtrl = "0";
        }
    }

    public boolean equals(MonLcasSinkData monLcasSinkData) {
        return monLcasSinkData != null && this.m_bInContext == monLcasSinkData.m_bInContext && this.m_bLoVCat == monLcasSinkData.m_bLoVCat && this.m_channelPos == monLcasSinkData.m_channelPos && this.m_nCurrSqi == monLcasSinkData.m_nCurrSqi && this.m_sCurrCtrl == monLcasSinkData.m_sCurrCtrl && this.m_CurrCtrlCombo == monLcasSinkData.m_CurrCtrlCombo;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MonLcasSinkData) {
            return this.equals((MonLcasSinkData)object);
        }
        return false;
    }

    public MaskedIntegerValue getActionCombo() {
        return this.m_ActionCombo;
    }

    public String getActiveState() {
        return this.m_sActiveState;
    }

    public int getChannelPos() {
        return this.m_channelPos;
    }

    public String getCurrCtrl() {
        return this.m_sCurrCtrl;
    }

    public MaskedIntegerValue getCurrCtrlCombo() {
        return this.m_CurrCtrlCombo;
    }

    public int getCurrSqi() {
        return this.m_nCurrSqi;
    }

    public boolean getLowOrderVCATEnabled() {
        return this.m_bLoVCat;
    }

    public boolean InContext() {
        return this.m_bInContext;
    }

    public void serialize(PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        primitiveTypesWriter.write(this.m_bInContext);
        primitiveTypesWriter.write(this.m_bLoVCat);
        primitiveTypesWriter.write(this.m_channelPos);
        primitiveTypesWriter.write(this.m_nCurrSqi);
        primitiveTypesWriter.write(this.m_sCurrCtrl);
        primitiveTypesWriter.write(this.m_CurrCtrlCombo.getValue());
        primitiveTypesWriter.write(this.m_CurrCtrlCombo.getOptionMask().getValue());
        primitiveTypesWriter.write(this.m_CurrCtrlCombo.getStateMask().getValue());
    }

    public void setChannelPos(int n) {
        this.m_channelPos = n;
    }

    public void setContext(boolean bl) {
        this.m_bInContext = bl;
    }

    public void setCurrCtrl(String string) {
        this.m_sCurrCtrl = string;
    }

    public void setCurrCtrlCombo(MaskedIntegerValue maskedIntegerValue) {
        this.m_CurrCtrlCombo = maskedIntegerValue;
    }

    public void setCurrSqi(byte by) {
        this.m_nCurrSqi = by;
    }

    public void setCurrSqi(int n) {
        this.m_nCurrSqi = n;
    }
}

