/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.AppSerializable;
import java.io.IOException;

public class MonLcasSourceData
implements AppSerializable {
    private boolean m_bInContext;
    private boolean m_bLoVCat;
    private int m_nCurrSqi;
    private MaskedIntegerValue m_CurrMSTCombo;

    public void deserialize(PrimitiveTypesReader primitiveTypesReader) throws IOException {
        MaskedIntegerValue maskedIntegerValue;
        this.m_bInContext = primitiveTypesReader.readBoolean();
        this.m_bLoVCat = primitiveTypesReader.readBoolean();
        this.m_nCurrSqi = primitiveTypesReader.readShort();
        byte by = primitiveTypesReader.readByte();
        primitiveTypesReader.readLong();
        primitiveTypesReader.readLong();
        this.m_CurrMSTCombo = maskedIntegerValue = new MaskedIntegerValue((int)by, 3L, 3L);
        if (!this.m_bInContext) {
            this.m_bLoVCat = false;
            this.m_nCurrSqi = 0;
        }
    }

    public boolean equals(MonLcasSourceData monLcasSourceData) {
        return monLcasSourceData != null && this.m_bInContext == monLcasSourceData.m_bInContext && this.m_bLoVCat == monLcasSourceData.m_bLoVCat && this.m_nCurrSqi == monLcasSourceData.m_nCurrSqi && this.m_CurrMSTCombo == monLcasSourceData.m_CurrMSTCombo;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MonLcasSourceData) {
            return this.equals((MonLcasSourceData)object);
        }
        return false;
    }

    public MaskedIntegerValue getCurrMSTCombo() {
        return this.m_CurrMSTCombo;
    }

    public int getCurrSqi() {
        return this.m_nCurrSqi;
    }

    public boolean getLowOrderVCATEnabled() {
        return this.m_bLoVCat;
    }

    public boolean InContext() {
        return this.m_bInContext;
    }

    public void serialize(PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        primitiveTypesWriter.write(this.m_bInContext);
        primitiveTypesWriter.write(this.m_nCurrSqi);
        primitiveTypesWriter.write(this.m_CurrMSTCombo.getValue());
        primitiveTypesWriter.write(this.m_CurrMSTCombo.getOptionMask().getValue());
        primitiveTypesWriter.write(this.m_CurrMSTCombo.getStateMask().getValue());
    }

    public void setContext(boolean bl) {
        this.m_bInContext = bl;
    }

    public void setCurrMST(MaskedIntegerValue maskedIntegerValue) {
        this.m_CurrMSTCombo = maskedIntegerValue;
    }

    public void setCurrSqi(byte by) {
        this.m_nCurrSqi = by;
    }

    public void setCurrSqi(int n) {
        this.m_nCurrSqi = n;
    }
}

