/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.AppSerializable;
import java.io.IOException;

public class MonLcasTraceSinkData
implements AppSerializable {
    private short m_bInContext;
    private short m_bLoVCat;
    private short m_nCurrElement;
    private String m_sCurrTime;
    private int m_channelPos;
    private short m_nCurrSqi;
    private MaskedIntegerValue m_CurrCtrlCombo;

    public void deserialize(PrimitiveTypesReader primitiveTypesReader) throws IOException {
        MaskedIntegerValue maskedIntegerValue;
        this.m_bInContext = primitiveTypesReader.readShort();
        this.m_bLoVCat = primitiveTypesReader.readShort();
        this.m_nCurrElement = primitiveTypesReader.readShort();
        this.m_channelPos = primitiveTypesReader.readInt();
        this.m_nCurrSqi = primitiveTypesReader.readShort();
        byte by = primitiveTypesReader.readByte();
        primitiveTypesReader.readLong();
        primitiveTypesReader.readLong();
        this.m_CurrCtrlCombo = maskedIntegerValue = new MaskedIntegerValue((int)by, 127L, 127L);
        this.m_sCurrTime = primitiveTypesReader.readString();
        if (this.m_bInContext == 0) {
            this.m_bLoVCat = 0;
            this.m_nCurrElement = 0;
            this.m_sCurrTime = "0";
            this.m_channelPos = 0;
            this.m_nCurrSqi = 0;
        }
    }

    public boolean equals(MonLcasTraceSinkData monLcasTraceSinkData) {
        return monLcasTraceSinkData != null && this.m_bInContext == monLcasTraceSinkData.m_bInContext && this.m_bLoVCat == monLcasTraceSinkData.m_bLoVCat && this.m_nCurrElement == monLcasTraceSinkData.m_nCurrElement && this.m_sCurrTime == monLcasTraceSinkData.m_sCurrTime && this.m_channelPos == monLcasTraceSinkData.m_channelPos && this.m_nCurrSqi == monLcasTraceSinkData.m_nCurrSqi && this.m_CurrCtrlCombo == monLcasTraceSinkData.m_CurrCtrlCombo;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MonLcasTraceSinkData) {
            return this.equals((MonLcasTraceSinkData)object);
        }
        return false;
    }

    public int getChannelPos() {
        return this.m_channelPos;
    }

    public MaskedIntegerValue getCurrCtrlCombo() {
        return this.m_CurrCtrlCombo;
    }

    public int getCurrElement() {
        return this.m_nCurrElement;
    }

    public int getCurrSqi() {
        return this.m_nCurrSqi;
    }

    public String getCurrTime() {
        return this.m_sCurrTime;
    }

    public short getLowOrderVCATEnabled() {
        return this.m_bLoVCat;
    }

    public short InContext() {
        return this.m_bInContext;
    }

    public void serialize(PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        primitiveTypesWriter.write(this.m_bInContext);
        primitiveTypesWriter.write(this.m_bLoVCat);
        primitiveTypesWriter.write(this.m_nCurrElement);
        primitiveTypesWriter.write(this.m_sCurrTime);
        primitiveTypesWriter.write(this.m_channelPos);
        primitiveTypesWriter.write(this.m_nCurrSqi);
        primitiveTypesWriter.write(this.m_CurrCtrlCombo.getValue());
        primitiveTypesWriter.write(this.m_CurrCtrlCombo.getOptionMask().getValue());
        primitiveTypesWriter.write(this.m_CurrCtrlCombo.getStateMask().getValue());
    }

    public void setChannelPos(int n) {
        this.m_channelPos = n;
    }

    public void setContext(short s) {
        this.m_bInContext = s;
    }

    public void setCurrCtrlCombo(MaskedIntegerValue maskedIntegerValue) {
        this.m_CurrCtrlCombo = maskedIntegerValue;
    }

    public void setCurrElement(short s) {
        this.m_nCurrElement = s;
    }

    public void setCurrSqi(short s) {
        this.m_nCurrSqi = s;
    }

    public void setCurrTime(String string) {
        this.m_sCurrTime = string;
    }
}

