/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.MaskedIntegerPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import java.io.IOException;

public class OtnPtReader
extends GenericDataReader {
    private static final int COMBO_BOX_ID = 1;
    private static final int LABEL_ID = 0;
    private static final int EXPERIMENTAL_MAPPING_INDEX = 0;
    private static final int ASYNCHRONOUS_MAPPING_INDEX = 1;
    private static final int BIT_SYNCHRONOUS_MAPPING_INDEX = 2;
    private static final int ATM_MAPPING_INDEX = 3;
    private static final int GFP_MAPPING_INDEX = 4;
    private static final int BIT_STREAM_WITH_OCTET_TIMING_MAPPING_INDEX = 5;
    private static final int BIT_STREAM_WITHOUT_OCTET_TIMING_MAPPING_INDEX = 6;
    private static final int NULL_TEST_SIGNAL_MAPPING_INDEX = 7;
    private static final int PRBS_TEST_SIGNAL_MAPPING_INDEX = 8;
    private static final int INVALID_INDEX = 9;
    private static final int RESERVED_INDEX = 10;
    private static final int EXCLUDED_INDEX = 11;
    private static final int PROPRIETARY_INDEX = 12;
    private static final int UNKNOWN_INDEX = 13;
    private static final int EXPERIMENTAL_MAPPING_VALUE = 1;
    private static final int ASYNCHRONOUS_MAPPING_VALUE = 2;
    private static final int BIT_SYNCHRONOUS_MAPPING_VALUE = 3;
    private static final int ATM_MAPPING_VALUE = 4;
    private static final int GFP_MAPPING_VALUE = 5;
    private static final int BIT_STREAM_WITH_OCTET_TIMING_MAPPING_VALUE = 16;
    private static final int BIT_STREAM_WITHOUT_OCTET_TIMING_MAPPING_VALUE = 17;
    private static final int NULL_TEST_SIGNAL_MAPPING_VALUE = 253;
    private static final int PRBS_TEST_SIGNAL_MAPPING_VALUE = 254;
    private static final int RESERVED1_LOWER_VALUE = 18;
    private static final int RESERVED1_UPPER_VALUE = 84;
    private static final int RESERVED2_LOWER_VALUE = 86;
    private static final int RESERVED2_UPPER_VALUE = 101;
    private static final int RESERVED3_LOWER_VALUE = 103;
    private static final int RESERVED3_UPPER_VALUE = 127;
    private static final int RESERVED4_LOWER_VALUE = 144;
    private static final int RESERVED4_UPPER_VALUE = 252;
    private static final int PROPRIETARY_LOWER_VALUE = 128;
    private static final int PROPRIETARY_UPPER_VALUE = 143;
    private static final int EXCLUDED0 = 0;
    private static final int EXCLUDED1 = 85;
    private static final int EXCLUDED2 = 102;
    private static final int EXCLUDED3 = 255;
    private static final int DEFAULT_MASK = 16383;
    int m_theValue;
    int m_theOldValue;
    boolean m_isValid;
    boolean m_dataReady;
    boolean m_repaintRequired;

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        try {
            this.m_theOldValue = this.m_theValue;
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            this.m_isValid = primitiveTypesReader.readBoolean();
            this.m_theValue = primitiveTypesReader.readInt();
            this.m_repaintRequired = this.m_theValue != this.m_theOldValue;
            this.m_dataReady = true;
        }
        catch (IOException iOException) {
            this.m_isValid = false;
            this.m_dataReady = false;
        }
        return true;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = this.m_dataReady;
        if (this.m_dataReady && (bl || this.m_repaintRequired)) {
            switch (n) {
                case 1: {
                    bl2 = this.updateComboBox(propertyAccessor);
                    break;
                }
                case 0: {
                    bl2 = this.updateBinaryLabel(propertyAccessor);
                }
            }
        }
        if (this.m_repaintRequired || bl) {
            propertyAccessor.repaint();
        }
        return bl2;
    }

    private boolean updateBinaryLabel(PropertyAccessor propertyAccessor) {
        String string;
        if (this.m_isValid) {
            string = Integer.toString(this.m_theValue, 2);
            while (string.length() < 8) {
                string = "0" + string;
            }
        } else {
            string = "....";
        }
        boolean bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
        return bl;
    }

    private boolean updateComboBox(PropertyAccessor propertyAccessor) {
        int n = 9;
        if (this.m_isValid) {
            if (this.m_theValue >= 18 && this.m_theValue <= 84) {
                n = 10;
            } else if (this.m_theValue >= 86 && this.m_theValue <= 101) {
                n = 10;
            } else if (this.m_theValue >= 103 && this.m_theValue <= 127) {
                n = 10;
            } else if (this.m_theValue >= 144 && this.m_theValue <= 252) {
                n = 10;
            } else if (this.m_theValue >= 128 && this.m_theValue <= 143) {
                n = 12;
            } else {
                switch (this.m_theValue) {
                    case 1: {
                        n = 0;
                        break;
                    }
                    case 2: {
                        n = 1;
                        break;
                    }
                    case 3: {
                        n = 2;
                        break;
                    }
                    case 4: {
                        n = 3;
                        break;
                    }
                    case 5: {
                        n = 4;
                        break;
                    }
                    case 16: {
                        n = 5;
                        break;
                    }
                    case 17: {
                        n = 6;
                        break;
                    }
                    case 253: {
                        n = 7;
                        break;
                    }
                    case 254: {
                        n = 8;
                        break;
                    }
                    case 0: 
                    case 85: 
                    case 102: 
                    case 255: {
                        n = 11;
                        break;
                    }
                    default: {
                        n = 13;
                    }
                }
            }
        }
        MaskedIntegerValue maskedIntegerValue = new MaskedIntegerValue(n, 16383L, 16383L);
        boolean bl = ((MaskedIntegerPropertyAccessor)propertyAccessor).setMaskedIntegerValue(maskedIntegerValue);
        return bl;
    }
}

