/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.lynx.overhead_usercode.CompositeReaderSupport;
import com.agilent.tntd.lynx.overhead_usercode.OvByteLabel;
import java.io.IOException;

public class OvByteLabelsReader
extends GenericDataReader {
    private int numElements;
    private OvByteLabel[] labelsArray;
    private OvByteLabel[] previousLabelsArray;
    private boolean dataReady;
    private boolean[] repaintRequired;
    private CompositeReaderSupport m_support;

    public OvByteLabelsReader(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.numElements = n;
        this.labelsArray = new OvByteLabel[this.numElements];
        this.previousLabelsArray = new OvByteLabel[this.numElements];
        this.repaintRequired = new boolean[this.numElements];
        int n2 = 0;
        while (n2 < this.labelsArray.length) {
            this.labelsArray[n2] = new OvByteLabel();
            this.previousLabelsArray[n2] = new OvByteLabel();
            ++n2;
        }
        this.m_support = new CompositeReaderSupport(n);
    }

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        try {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            this.m_support.deserialize(primitiveTypesReader, this.labelsArray, this.previousLabelsArray, this.repaintRequired);
            this.dataReady = true;
        }
        catch (IOException iOException) {
            this.dataReady = false;
        }
        return true;
    }

    private boolean setLabelProperties(int n, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        if (propertyAccessor instanceof TextPropertyAccessor) {
            bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(this.labelsArray[n].getLabel());
        }
        return bl;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = false;
        if (this.labelsArray != null && n < this.labelsArray.length) {
            bl2 = true;
            if (this.repaintRequired[n] || bl) {
                bl2 = this.setLabelProperties(n, propertyAccessor);
            }
            if (this.repaintRequired[n]) {
                propertyAccessor.repaint();
            }
        }
        return bl2;
    }
}

