/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.lynx.overhead_usercode.CompositeReaderSupport;
import com.agilent.tntd.lynx.overhead_usercode.OvMonByteData;
import java.io.IOException;

public class OvMonBytesReader
extends GenericDataReader {
    private int numElements;
    private OvMonByteData[] monitorBytes;
    private OvMonByteData[] previousMonitorBytes;
    private boolean dataReady;
    private static final int HEX_FORMAT = 0;
    private static final int BINARY_FORMAT = 1;
    private boolean[] repaintRequired;
    private CompositeReaderSupport m_support;

    public OvMonBytesReader(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.numElements = n;
        this.monitorBytes = new OvMonByteData[this.numElements];
        this.previousMonitorBytes = new OvMonByteData[this.numElements];
        int n2 = 0;
        while (n2 < this.monitorBytes.length) {
            this.monitorBytes[n2] = new OvMonByteData();
            this.monitorBytes[n2].setValid(true);
            this.previousMonitorBytes[n2] = new OvMonByteData();
            this.previousMonitorBytes[n2].setValid(true);
            ++n2;
        }
        this.repaintRequired = new boolean[this.numElements];
        this.m_support = new CompositeReaderSupport(this.numElements);
    }

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        try {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            boolean bl = primitiveTypesReader.readBoolean();
            int n = 0;
            while (n < this.previousMonitorBytes.length) {
                this.previousMonitorBytes[n].setValid(bl);
                ++n;
            }
            this.m_support.deserialize(primitiveTypesReader, this.monitorBytes, this.previousMonitorBytes, this.repaintRequired);
            this.dataReady = true;
        }
        catch (IOException iOException) {
            this.dataReady = false;
        }
        return true;
    }

    public int getNumElements() {
        return this.numElements;
    }

    private boolean setBinaryTextProperty(int n, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        if (propertyAccessor instanceof TextPropertyAccessor) {
            OvMonByteData ovMonByteData = this.monitorBytes[n];
            bl = !ovMonByteData.isValid() ? ((TextPropertyAccessor)propertyAccessor).setTextProperty("....") : ((TextPropertyAccessor)propertyAccessor).setTextProperty(ovMonByteData.toBinaryString());
        }
        return bl;
    }

    private boolean setGreyingProperty(int n, PropertyAccessor propertyAccessor) {
        boolean bl = true;
        if (propertyAccessor instanceof GreyPropertyAccessor) {
            bl = ((GreyPropertyAccessor)propertyAccessor).setGreyProperty(false);
        }
        return bl;
    }

    private boolean setHexTextProperty(int n, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        if (propertyAccessor instanceof TextPropertyAccessor) {
            OvMonByteData ovMonByteData = this.monitorBytes[n];
            bl = !ovMonByteData.isValid() ? ((TextPropertyAccessor)propertyAccessor).setTextProperty("..") : ((TextPropertyAccessor)propertyAccessor).setTextProperty(ovMonByteData.toHexString());
        }
        return bl;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = this.dataReady;
        int n2 = n % this.numElements;
        if (this.dataReady) {
            switch (n / this.numElements) {
                case 0: {
                    bl2 = this.setHexTextProperty(n2, propertyAccessor);
                    if (bl) {
                        bl2 &= this.setGreyingProperty(n2, propertyAccessor);
                    }
                    propertyAccessor.repaint();
                    break;
                }
                case 1: {
                    bl2 = this.setBinaryTextProperty(n2, propertyAccessor);
                    if (bl) {
                        bl2 &= this.setGreyingProperty(n2, propertyAccessor);
                    }
                    propertyAccessor.repaint();
                }
            }
        }
        return bl2;
    }
}

