/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.AppSerializable;
import java.io.IOException;

public class OvMonTrcMsgData
implements AppSerializable {
    public static final int MAX_MESSAGE_LENGTH = 64;
    private int messageLength = 16;
    private byte[] rawData = new byte[64];
    private boolean crcFound = true;
    private boolean crcPassed = true;
    private boolean m_valid = true;

    public void deserialize(PrimitiveTypesReader primitiveTypesReader) throws IOException {
        this.crcFound = primitiveTypesReader.readBoolean();
        this.crcPassed = primitiveTypesReader.readBoolean();
        this.messageLength = primitiveTypesReader.readShort();
        int n = 0;
        while (n < this.messageLength) {
            this.rawData[n] = primitiveTypesReader.readByte();
            n = (short)(n + 1);
        }
    }

    public boolean equals(OvMonTrcMsgData ovMonTrcMsgData) {
        if (ovMonTrcMsgData != null) {
            return this.rawData.equals(ovMonTrcMsgData.rawData) && this.crcPassed == ovMonTrcMsgData.crcPassed && this.crcFound == ovMonTrcMsgData.crcFound;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof OvMonTrcMsgData) {
            return this.equals((OvMonTrcMsgData)object);
        }
        return false;
    }

    public boolean isCrcFound() {
        return this.crcFound;
    }

    public boolean isCrcPassed() {
        return this.crcPassed;
    }

    public int length() {
        return this.messageLength;
    }

    public void serialize(PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        primitiveTypesWriter.write(this.crcFound);
        primitiveTypesWriter.write(this.crcPassed);
        primitiveTypesWriter.write(this.messageLength);
        int n = 0;
        while (n < this.messageLength) {
            primitiveTypesWriter.write(this.rawData[n]);
            n = (short)(n + 1);
        }
    }

    public String toAsciiString() {
        return new String(this.rawData, 0, this.messageLength);
    }

    public String toBinaryString() {
        StringBuffer stringBuffer = new StringBuffer(this.messageLength * 8);
        int n = 0;
        while (n < this.messageLength) {
            String string = Integer.toString(this.rawData[n] & 0xFF, 2);
            while (string.length() != 8) {
                string = "0" + string;
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toHexString() {
        StringBuffer stringBuffer = new StringBuffer(this.messageLength * 2);
        int n = 0;
        while (n < this.messageLength) {
            String string = Integer.toString(this.rawData[n] & 0xFF, 16);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString().toUpperCase();
    }
}

