/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.IndexPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.lynx.overhead_usercode.OvMonTrcMsgData;
import java.io.IOException;

public class OvMonTrcMsgReader
extends GenericDataReader {
    private static final int PANE_ID = 0;
    private static final int FIXED_BYTE_ID = 1;
    private static final int BYTE_15_ID = 2;
    private static final int BYTE_16_ID = 3;
    private static final int BYTE_64_ID_1 = 4;
    private static final int BYTE_64_ID_2 = 5;
    private OvMonTrcMsgData trc = new OvMonTrcMsgData();
    private OvMonTrcMsgData oldTrc = new OvMonTrcMsgData();
    private boolean dataReady;
    private boolean valid = true;
    private boolean repaintRequired = true;

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        this.repaintRequired = true;
        try {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            boolean bl = primitiveTypesReader.readBoolean();
            OvMonTrcMsgData ovMonTrcMsgData = this.trc;
            this.trc = this.oldTrc;
            this.oldTrc = ovMonTrcMsgData;
            this.trc.deserialize(primitiveTypesReader);
            if (bl == this.valid && this.trc.equals(this.oldTrc)) {
                this.repaintRequired = false;
            }
            this.dataReady = true;
            this.valid = bl;
        }
        catch (IOException iOException) {
            this.dataReady = false;
        }
        return true;
    }

    private String mapString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            byte by = (byte)stringBuffer.charAt(n);
            if (by == 14 || by == 15 || by == 16) {
                stringBuffer.setCharAt(n, '\u0001');
            } else if (by == 0) {
                stringBuffer.setCharAt(n, '\u000e');
            } else if (by == 10) {
                stringBuffer.setCharAt(n, '\u000f');
            } else if (by == 13) {
                stringBuffer.setCharAt(n, '\u0010');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private boolean messageLengthMatch(int n) {
        switch (n) {
            case 1: {
                return this.trc.length() == 1;
            }
            case 2: {
                return this.trc.length() == 15;
            }
            case 3: {
                return this.trc.length() == 16;
            }
            case 4: 
            case 5: {
                return this.trc.length() == 64;
            }
        }
        return false;
    }

    private boolean setPaneProperties(int n, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        if (propertyAccessor instanceof IndexPropertyAccessor) {
            int n2 = 0;
            switch (this.trc.length()) {
                case 1: {
                    n2 = 0;
                    break;
                }
                case 15: {
                    n2 = 1;
                    break;
                }
                case 16: {
                    n2 = 2;
                    break;
                }
                case 64: {
                    n2 = 3;
                    break;
                }
                default: {
                    n2 = 2;
                }
            }
            bl = ((IndexPropertyAccessor)propertyAccessor).setIndexProperty(n2);
            propertyAccessor.repaint();
        }
        return bl;
    }

    private boolean setTextProperties(int n, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        if (!this.messageLengthMatch(n)) {
            return true;
        }
        if (propertyAccessor instanceof TextPropertyAccessor) {
            if (!this.valid) {
                switch (n) {
                    case 1: {
                        bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty("........");
                        break;
                    }
                    case 4: 
                    case 5: {
                        bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty("................................");
                        break;
                    }
                    default: {
                        bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty("...............");
                        break;
                    }
                }
            } else {
                switch (n) {
                    case 1: {
                        bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(this.trc.toBinaryString());
                        break;
                    }
                    case 4: {
                        bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(this.mapString(this.trc.toAsciiString().substring(0, 32)));
                        break;
                    }
                    case 5: {
                        bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(this.mapString(this.trc.toAsciiString().substring(32, 64)));
                        break;
                    }
                    default: {
                        bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(this.mapString(this.trc.toAsciiString()));
                    }
                }
            }
        }
        propertyAccessor.repaint();
        return bl;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = this.dataReady;
        if (this.dataReady && (bl || this.repaintRequired)) {
            switch (n) {
                case 0: {
                    bl2 = this.setPaneProperties(n, propertyAccessor);
                    break;
                }
                case 1: {
                    bl2 = this.setTextProperties(n, propertyAccessor);
                    break;
                }
                case 2: {
                    bl2 = this.setTextProperties(n, propertyAccessor);
                    break;
                }
                case 3: {
                    bl2 = this.setTextProperties(n, propertyAccessor);
                    break;
                }
                case 4: {
                    bl2 = this.setTextProperties(n, propertyAccessor);
                    break;
                }
                case 5: {
                    bl2 = this.setTextProperties(n, propertyAccessor);
                }
            }
        }
        return bl2;
    }
}

