/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.LockableBooleanPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.datatype.LockableBoolean;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.CompositeReaderSupport;
import com.agilent.tntd.lynx.overhead_usercode.OvSeqFocusByteData;
import java.io.IOException;

public class OvSeqFocusBytesReader
extends GenericDataReader {
    private int numElements;
    private boolean[] repaintRequired;
    private OvSeqFocusByteData[] focusBytes;
    private OvSeqFocusByteData[] previousFocusBytes;
    private boolean dataReady;
    private CompositeReaderSupport m_support;

    public OvSeqFocusBytesReader(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.numElements = n;
        this.focusBytes = new OvSeqFocusByteData[this.numElements];
        this.previousFocusBytes = new OvSeqFocusByteData[this.numElements];
        int n2 = 0;
        while (n2 < this.focusBytes.length) {
            this.focusBytes[n2] = new OvSeqFocusByteData();
            this.previousFocusBytes[n2] = new OvSeqFocusByteData();
            ++n2;
        }
        this.repaintRequired = new boolean[this.numElements];
        this.m_support = new CompositeReaderSupport(this.numElements);
    }

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        try {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            this.m_support.deserialize(primitiveTypesReader, this.focusBytes, this.previousFocusBytes, this.repaintRequired);
            this.dataReady = true;
        }
        catch (IOException iOException) {
            this.dataReady = false;
        }
        return true;
    }

    public OvSeqFocusByteData[] getFocusBytes() {
        return this.focusBytes;
    }

    public boolean isDataReady() {
        return this.dataReady;
    }

    public ApplicationData modifyDataToChange(ApplicationData applicationData) {
        ApplicationData applicationData2 = applicationData;
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            int n = this.m_support.getChangeCompositeID(applicationData);
            boolean bl = ((LockableBoolean)applicationData).isTrue();
            boolean bl2 = ((LockableBoolean)applicationData).isLocked();
            this.m_support.writeChangeIndex(n, (PrimitiveTypesWriter)simpleTypesWriter);
            simpleTypesWriter.write(bl);
            simpleTypesWriter.write(bl2);
            applicationData2 = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
        }
        catch (IOException iOException) {
            EventLog.instance().log("Could not read the meta data from this ecldataentry, or write the data to send to the server.");
        }
        catch (ClassCastException classCastException) {
            EventLog.instance().log("OvSeqFocusBytesReader - unexpected application data type was received! ");
        }
        return applicationData2;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = this.dataReady;
        int n2 = n % this.numElements;
        if (this.dataReady && (bl || this.repaintRequired[n2])) {
            if (propertyAccessor instanceof TextPropertyAccessor) {
                bl2 &= ((TextPropertyAccessor)propertyAccessor).setTextProperty("");
                bl2 &= this.updateButton(bl2, propertyAccessor, n2);
                propertyAccessor.repaint();
            } else {
                bl2 = false;
            }
        }
        return bl2;
    }

    public boolean updateButton(boolean bl, PropertyAccessor propertyAccessor, int n) {
        if (bl && propertyAccessor instanceof LockableBooleanPropertyAccessor) {
            bl &= ((LockableBooleanPropertyAccessor)propertyAccessor).setLockableBooleanProperty(new LockableBoolean(this.focusBytes[n].getActive(), this.focusBytes[n].getLocked()));
        }
        return bl &= ((GreyPropertyAccessor)propertyAccessor).setGreyProperty(false);
    }
}

