/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.AppSerializable;
import java.io.IOException;

public class OvSetupByteData
implements AppSerializable {
    private byte value;
    private byte defaultValue;
    private byte readMask;
    private byte writeMask;

    public boolean controllable() {
        return this.writeMask != 0;
    }

    public void deserialize(PrimitiveTypesReader primitiveTypesReader) throws IOException {
        this.value = primitiveTypesReader.readByte();
        this.defaultValue = primitiveTypesReader.readByte();
        this.writeMask = primitiveTypesReader.readByte();
        this.readMask = primitiveTypesReader.readByte();
    }

    public boolean equals(OvSetupByteData ovSetupByteData) {
        return ovSetupByteData != null && this.value == ovSetupByteData.value && this.defaultValue == ovSetupByteData.defaultValue && this.readMask == ovSetupByteData.readMask && this.writeMask == ovSetupByteData.writeMask;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof OvSetupByteData) {
            return this.equals((OvSetupByteData)object);
        }
        return false;
    }

    public byte getValue() {
        return this.value;
    }

    public boolean readable() {
        return this.readMask != 0;
    }

    public void serialize(PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        primitiveTypesWriter.write(this.value);
        primitiveTypesWriter.write(this.defaultValue);
        primitiveTypesWriter.write(this.writeMask);
        primitiveTypesWriter.write(this.readMask);
    }

    public void SetValue(byte by) {
        this.value = by;
    }

    public String toAsciiString() {
        byte[] byArray = new byte[]{this.value};
        return new String(byArray);
    }

    public String toBinaryString() {
        return this.toBinaryStringImpl(this.value);
    }

    private String toBinaryStringImpl(byte by) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(by & 0xFF, 2));
        while (stringBuffer.length() != 8) {
            stringBuffer.insert(0, "0");
        }
        int n = this.readMask & 0xFF;
        int n2 = 7;
        while (n2 >= 0) {
            if ((n & 1 << n2) == 0) {
                stringBuffer.setCharAt(7 - n2, 'X');
            }
            --n2;
        }
        return stringBuffer.toString();
    }

    public String toDefBinaryString() {
        return this.toBinaryStringImpl(this.defaultValue);
    }

    public String toDefHexString() {
        return this.toHexStringImpl(this.defaultValue);
    }

    public String toHexString() {
        return this.toHexStringImpl(this.value);
    }

    private String toHexStringImpl(byte by) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(by & 0xFF, 16).toUpperCase());
        if (stringBuffer.length() == 1) {
            stringBuffer.insert(0, '0');
        }
        if ((this.readMask & 0xF0) == 0) {
            stringBuffer.setCharAt(0, 'X');
        }
        if ((this.readMask & 0xF) == 0) {
            stringBuffer.setCharAt(1, 'X');
        }
        return stringBuffer.toString();
    }
}

