/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.EditablePropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.CompositeReaderSupport;
import com.agilent.tntd.lynx.overhead_usercode.OvSetupByteData;
import java.io.IOException;

public class OvSetupBytesReader
extends GenericDataReader {
    private int numElements;
    private OvSetupByteData[] setupBytes;
    private OvSetupByteData[] previousSetupBytes;
    private boolean dataReady;
    private static final int HEX_FORMAT = 0;
    private static final int BINARY_FORMAT = 1;
    private boolean[] repaintRequired;
    private CompositeReaderSupport m_support;

    public OvSetupBytesReader(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.numElements = n;
        this.setupBytes = new OvSetupByteData[this.numElements];
        this.previousSetupBytes = new OvSetupByteData[this.numElements];
        int n2 = 0;
        while (n2 < this.setupBytes.length) {
            this.setupBytes[n2] = new OvSetupByteData();
            this.previousSetupBytes[n2] = new OvSetupByteData();
            ++n2;
        }
        this.repaintRequired = new boolean[this.numElements];
        this.m_support = new CompositeReaderSupport(this.numElements);
    }

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        try {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            this.m_support.deserialize(primitiveTypesReader, this.setupBytes, this.previousSetupBytes, this.repaintRequired);
            this.dataReady = true;
        }
        catch (IOException iOException) {
            this.dataReady = false;
        }
        return true;
    }

    private String getBinaryPresets(int n) {
        return "," + this.setupBytes[n].toDefBinaryString() + " Default,,,";
    }

    private String getHexPresets(int n) {
        return "," + this.setupBytes[n].toDefHexString() + " Default,,,";
    }

    private String getHistory(int n) {
        return ",  ,  ,  ,  ";
    }

    private int getNumElements() {
        return this.numElements;
    }

    public ApplicationData modifyDataToChange(ApplicationData applicationData) {
        ApplicationData applicationData2 = applicationData;
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            int n = this.m_support.getChangeCompositeID(applicationData);
            int n2 = n % this.numElements;
            this.m_support.writeChangeIndex(n2, (PrimitiveTypesWriter)simpleTypesWriter);
            switch (n / this.numElements) {
                case 0: {
                    this.writeNewHexByteData(n2, ((KnownLengthStringValue)applicationData).getValue(), (PrimitiveTypesWriter)simpleTypesWriter);
                    break;
                }
                case 1: {
                    this.writeNewBinaryByteData(n2, ((KnownLengthStringValue)applicationData).getValue(), (PrimitiveTypesWriter)simpleTypesWriter);
                }
            }
            applicationData2 = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
        }
        catch (IOException iOException) {
            EventLog.instance().log("Could not read the meta data from this ecldataentry, or write the data to send to the server.");
        }
        catch (ClassCastException classCastException) {
            EventLog.instance().log("OvSetupBytesReader - unexpected application data type was received! ");
        }
        return applicationData2;
    }

    private boolean setBinaryTextProperty(int n, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        if (propertyAccessor instanceof TextPropertyAccessor) {
            OvSetupByteData ovSetupByteData = this.setupBytes[n];
            bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(ovSetupByteData.toBinaryString());
        }
        return bl;
    }

    private boolean setEditableProperty(int n, PropertyAccessor propertyAccessor) {
        boolean bl = true;
        if (propertyAccessor instanceof EditablePropertyAccessor) {
            OvSetupByteData ovSetupByteData = this.setupBytes[n];
            bl = ((EditablePropertyAccessor)propertyAccessor).setEditableProperty(ovSetupByteData.controllable());
        }
        return bl;
    }

    private boolean setGreyingProperty(int n, PropertyAccessor propertyAccessor) {
        boolean bl = true;
        if (propertyAccessor instanceof GreyPropertyAccessor) {
            OvSetupByteData cfr_ignored_0 = this.setupBytes[n];
            bl = ((GreyPropertyAccessor)propertyAccessor).setGreyProperty(false);
        }
        return bl;
    }

    private boolean setHexTextProperty(int n, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        if (propertyAccessor instanceof TextPropertyAccessor) {
            OvSetupByteData ovSetupByteData = this.setupBytes[n];
            bl = ovSetupByteData.controllable() ? ((TextPropertyAccessor)propertyAccessor).setTextProperty(String.valueOf(ovSetupByteData.toHexString()) + this.getHistory(n) + this.getHexPresets(n)) : ((TextPropertyAccessor)propertyAccessor).setTextProperty(ovSetupByteData.toHexString());
        }
        return bl;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = this.dataReady;
        int n2 = n % this.numElements;
        if (this.dataReady && (bl || this.repaintRequired[n2])) {
            switch (n / this.numElements) {
                case 0: {
                    bl2 = this.setHexTextProperty(n2, propertyAccessor) & this.setEditableProperty(n2, propertyAccessor);
                    if (bl) {
                        bl2 &= this.setGreyingProperty(n2, propertyAccessor);
                    }
                    propertyAccessor.repaint();
                    break;
                }
                case 1: {
                    bl2 = this.setBinaryTextProperty(n2, propertyAccessor) & this.setEditableProperty(n2, propertyAccessor);
                    if (bl) {
                        bl2 &= this.setGreyingProperty(n2, propertyAccessor);
                    }
                    propertyAccessor.repaint();
                }
            }
        }
        return bl2;
    }

    private void writeNewBinaryByteData(int n, String string, PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        string = string.replace('x', '0').replace('X', '0');
        int n2 = Integer.parseInt(string, 2);
        primitiveTypesWriter.write((byte)n2);
    }

    private void writeNewHexByteData(int n, String string, PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        string = string.replace('x', '0').replace('X', '0');
        while (string.length() < 2) {
            string = "0" + string;
        }
        int n2 = Integer.parseInt(string.substring(0, 2), 16);
        primitiveTypesWriter.write((byte)n2);
    }
}

