/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.AppSerializable;
import java.io.IOException;

public class OvSetupTrcMsgData
implements AppSerializable {
    private static final byte CHANGE_MSG = 0;
    private static final byte SET_NULL = 1;
    private static final byte SET_TEST = 2;
    private static final byte FIXED_BYTE = 0;
    private static final byte BYTE_15 = 1;
    private static final byte BYTE_16 = 2;
    private static final byte BYTE_64 = 3;
    private boolean m_bGrey = false;
    private byte[] m_fixedByte = new byte[1];
    private byte[] m_byte15 = new byte[15];
    private byte[] m_byte16 = new byte[16];
    private byte[] m_byte64 = new byte[64];
    private static final String PRESET1 = "Null Msg";
    private static final String PRESET2 = "Test Msg";
    private static final String BYTE15_STR = ",               ,               ,               ,               ,Null Msg,Test Msg,,,";
    private static final String BYTE16_STR = ",                ,                ,                ,                ,Null Msg,Test Msg,,,";
    private static final String BYTE64_1_STR = ",                                ,                                ,                                ,                                ,Null Msg,Test Msg,,,";
    private static final String BYTE64_2_STR = ",                                ,                                ,                                ,                                ,Null Msg,Test Msg,,,";

    public void change15ByteMessage(String string, PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        if (this.presetWritten(string, primitiveTypesWriter, (byte)1)) {
            return;
        }
        byte[] byArray = string.getBytes();
        this.mapToServer(byArray);
        primitiveTypesWriter.write((byte)0);
        primitiveTypesWriter.write((byte)1);
        this.write(byArray, primitiveTypesWriter);
    }

    public void change16ByteMessage(String string, PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        if (this.presetWritten(string, primitiveTypesWriter, (byte)2)) {
            return;
        }
        byte[] byArray = string.getBytes();
        this.mapToServer(byArray);
        primitiveTypesWriter.write((byte)0);
        primitiveTypesWriter.write((byte)2);
        this.write(byArray, primitiveTypesWriter);
    }

    public void change64_1ByteMessage(String string, PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        if (this.presetWritten(string, primitiveTypesWriter, (byte)3)) {
            return;
        }
        byte[] byArray = string.getBytes();
        if (byArray.length == 32) {
            byte[] byArray2 = new byte[64];
            System.arraycopy(byArray, 0, byArray2, 0, 32);
            System.arraycopy(this.m_byte64, 32, byArray2, 32, 32);
            byArray = byArray2;
        }
        this.mapToServer(byArray);
        primitiveTypesWriter.write((byte)0);
        primitiveTypesWriter.write((byte)3);
        this.write(byArray, primitiveTypesWriter);
    }

    public void change64_2ByteMessage(String string, PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        if (this.presetWritten(string, primitiveTypesWriter, (byte)3)) {
            return;
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[32 + byArray.length];
        System.arraycopy(this.m_byte64, 0, byArray2, 0, 32);
        System.arraycopy(byArray, 0, byArray2, 32, byArray.length);
        byArray = byArray2;
        this.mapToServer(byArray);
        primitiveTypesWriter.write((byte)0);
        primitiveTypesWriter.write((byte)3);
        this.write(byArray, primitiveTypesWriter);
    }

    public void changeFixedByte(String string, PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        int n = Integer.parseInt(string.replace('X', '0'), 2);
        primitiveTypesWriter.write((byte)0);
        primitiveTypesWriter.write((byte)0);
        primitiveTypesWriter.write((byte)1);
        primitiveTypesWriter.write((byte)n);
    }

    public void deserialize(PrimitiveTypesReader primitiveTypesReader) throws IOException {
        this.m_bGrey = primitiveTypesReader.readBoolean();
        this.read(this.m_fixedByte, primitiveTypesReader);
        this.read(this.m_byte15, primitiveTypesReader);
        this.read(this.m_byte16, primitiveTypesReader);
        this.read(this.m_byte64, primitiveTypesReader);
        this.mapToGui(this.m_byte15);
        this.mapToGui(this.m_byte16);
        this.mapToGui(this.m_byte64);
    }

    public String get15ByteMessage() {
        return String.valueOf(new String(this.m_byte15, 0, 15)) + BYTE15_STR;
    }

    public String get16ByteMessage() {
        return String.valueOf(new String(this.m_byte16, 0, 16)) + BYTE16_STR;
    }

    public String getFirstHalfOf64ByteMessage() {
        return String.valueOf(new String(this.m_byte64, 0, 32)) + ",                                ,                                ,                                ,                                ,Null Msg,Test Msg,,,";
    }

    public String getFixedByte() {
        StringBuffer stringBuffer = new StringBuffer("00000000");
        String string = Integer.toBinaryString(this.m_fixedByte[0] & 0xFF);
        int n = stringBuffer.length() - string.length();
        int n2 = 0;
        while (n < stringBuffer.length()) {
            stringBuffer.setCharAt(n, string.charAt(n2));
            ++n;
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String getSecondHalfOf64ByteMessage() {
        return String.valueOf(new String(this.m_byte64, 32, 32)) + ",                                ,                                ,                                ,                                ,Null Msg,Test Msg,,,";
    }

    public boolean InContext() {
        return this.m_bGrey;
    }

    private void mapToGui(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            switch (byArray[n]) {
                case 0: {
                    byArray[n] = 14;
                    break;
                }
                case 10: {
                    byArray[n] = 15;
                    break;
                }
                case 13: {
                    byArray[n] = 16;
                }
            }
            ++n;
        }
    }

    private void mapToServer(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            switch (byArray[n]) {
                case 14: {
                    byArray[n] = 0;
                    break;
                }
                case 15: {
                    byArray[n] = 10;
                    break;
                }
                case 16: {
                    byArray[n] = 13;
                }
            }
            ++n;
        }
    }

    private boolean presetWritten(String string, PrimitiveTypesWriter primitiveTypesWriter, byte by) throws IOException {
        boolean bl = false;
        if (string.equalsIgnoreCase(PRESET1)) {
            primitiveTypesWriter.write((byte)1);
            primitiveTypesWriter.write(by);
            bl = true;
        } else if (string.equalsIgnoreCase(PRESET2)) {
            primitiveTypesWriter.write((byte)2);
            primitiveTypesWriter.write(by);
            bl = true;
        }
        return bl;
    }

    private void read(byte[] byArray, PrimitiveTypesReader primitiveTypesReader) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = primitiveTypesReader.readByte();
            ++n;
        }
    }

    public void serialize(PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
    }

    private void write(byte[] byArray, PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        primitiveTypesWriter.write((byte)byArray.length);
        int n = 0;
        while (n < byArray.length) {
            primitiveTypesWriter.write(byArray[n]);
            ++n;
        }
    }
}

