/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.middleware.SimpleTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.OvSetupTrcMsgData;
import java.io.IOException;

public class OvSetupTrcMsgReader
extends GenericDataReader {
    private static final int FIXED_BYTE_ID = 2;
    private static final int BYTE_15_ID = 3;
    private static final int BYTE_16_ID = 4;
    private static final int BYTE_64_ID_1 = 5;
    private static final int BYTE_64_ID_2 = 6;
    private OvSetupTrcMsgData m_trc = new OvSetupTrcMsgData();
    private boolean dataReady;

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        try {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            this.m_trc.deserialize(primitiveTypesReader);
            this.dataReady = true;
        }
        catch (IOException iOException) {
            this.dataReady = false;
        }
        return true;
    }

    public ApplicationData modifyDataToChange(ApplicationData applicationData) {
        ApplicationGenericData applicationGenericData;
        ApplicationGenericMetaData applicationGenericMetaData = (ApplicationGenericMetaData)applicationData.description();
        SimpleTypesReader simpleTypesReader = new SimpleTypesReader();
        SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
        simpleTypesReader.initialiseByteArrayToRead(applicationGenericMetaData.getByteArray());
        simpleTypesWriter.initialiseByteArrayToWrite();
        try {
            int n = simpleTypesReader.readInt();
            String string = ((KnownLengthStringValue)applicationData).getValue();
            switch (n) {
                case 2: {
                    this.m_trc.changeFixedByte(string, (PrimitiveTypesWriter)simpleTypesWriter);
                    break;
                }
                case 3: {
                    this.m_trc.change15ByteMessage(string, (PrimitiveTypesWriter)simpleTypesWriter);
                    break;
                }
                case 4: {
                    this.m_trc.change16ByteMessage(string, (PrimitiveTypesWriter)simpleTypesWriter);
                    break;
                }
                case 5: {
                    this.m_trc.change64_1ByteMessage(string, (PrimitiveTypesWriter)simpleTypesWriter);
                    break;
                }
                case 6: {
                    this.m_trc.change64_2ByteMessage(string, (PrimitiveTypesWriter)simpleTypesWriter);
                }
            }
            applicationGenericData = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
        }
        catch (IOException iOException) {
            EventLog.instance().log("Could not read the meta data from the component, or write the data to send to the server.");
            applicationGenericData = new ApplicationGenericData(null);
        }
        return applicationGenericData;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = false;
        GreyPropertyAccessor greyPropertyAccessor = (GreyPropertyAccessor)propertyAccessor;
        TextPropertyAccessor textPropertyAccessor = (TextPropertyAccessor)propertyAccessor;
        if (this.dataReady) {
            bl2 = greyPropertyAccessor.setGreyProperty(!this.m_trc.InContext());
            switch (n) {
                case 2: {
                    bl2 &= textPropertyAccessor.setTextProperty(this.m_trc.getFixedByte());
                    break;
                }
                case 3: {
                    bl2 &= textPropertyAccessor.setTextProperty(this.m_trc.get15ByteMessage());
                    break;
                }
                case 4: {
                    bl2 &= textPropertyAccessor.setTextProperty(this.m_trc.get16ByteMessage());
                    break;
                }
                case 5: {
                    bl2 &= textPropertyAccessor.setTextProperty(this.m_trc.getFirstHalfOf64ByteMessage());
                    break;
                }
                case 6: {
                    bl2 &= textPropertyAccessor.setTextProperty(this.m_trc.getSecondHalfOf64ByteMessage());
                }
            }
            propertyAccessor.repaint();
        }
        return bl2;
    }
}

