/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.overhead_usercode;

import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.AppSerializable;
import java.io.IOException;

public class SetupLcasSourceData
implements AppSerializable {
    private boolean m_bInContext;
    private boolean m_bLoVCat;
    private int m_channelPos;
    private int m_nCurrSqi;
    private String m_sNewSqi;
    private String m_sCurrCtrl;
    private MaskedIntegerValue m_CurrCtrlCombo;
    private String m_sNewCtrl;
    private MaskedIntegerValue m_NewCtrlCombo;

    public void deserialize(PrimitiveTypesReader primitiveTypesReader) throws IOException {
        MaskedIntegerValue maskedIntegerValue;
        MaskedIntegerValue maskedIntegerValue2;
        this.m_bInContext = primitiveTypesReader.readBoolean();
        this.m_bLoVCat = primitiveTypesReader.readBoolean();
        this.m_channelPos = primitiveTypesReader.readInt();
        this.m_nCurrSqi = primitiveTypesReader.readShort();
        this.m_sCurrCtrl = primitiveTypesReader.readString();
        byte by = primitiveTypesReader.readByte();
        long l = primitiveTypesReader.readLong();
        long l2 = primitiveTypesReader.readLong();
        this.m_CurrCtrlCombo = maskedIntegerValue2 = new MaskedIntegerValue((int)by, l, l2);
        by = primitiveTypesReader.readByte();
        l = primitiveTypesReader.readLong();
        l2 = primitiveTypesReader.readLong();
        this.m_NewCtrlCombo = maskedIntegerValue = new MaskedIntegerValue((int)by, l, l2);
        this.m_sNewSqi = primitiveTypesReader.readString();
        this.m_sNewCtrl = primitiveTypesReader.readString();
        if (!this.m_bInContext) {
            this.m_bLoVCat = false;
            this.m_channelPos = 0;
            this.m_nCurrSqi = 0;
            this.m_sNewSqi = "0";
            this.m_sCurrCtrl = "0";
            this.m_sNewCtrl = "0";
        }
    }

    public boolean equals(SetupLcasSourceData setupLcasSourceData) {
        return setupLcasSourceData != null && this.m_bInContext == setupLcasSourceData.m_bInContext && this.m_bLoVCat == setupLcasSourceData.m_bLoVCat && this.m_channelPos == setupLcasSourceData.m_channelPos && this.m_nCurrSqi == setupLcasSourceData.m_nCurrSqi && this.m_sNewSqi == setupLcasSourceData.m_sNewSqi && this.m_sCurrCtrl == setupLcasSourceData.m_sCurrCtrl && this.m_CurrCtrlCombo == setupLcasSourceData.m_CurrCtrlCombo && this.m_sNewCtrl == setupLcasSourceData.m_sNewCtrl && this.m_NewCtrlCombo == setupLcasSourceData.m_NewCtrlCombo;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SetupLcasSourceData) {
            return this.equals((SetupLcasSourceData)object);
        }
        return false;
    }

    public int getChannelPos() {
        return this.m_channelPos;
    }

    public String getCurrCtrl() {
        return this.m_sCurrCtrl;
    }

    public MaskedIntegerValue getCurrCtrlCombo() {
        return this.m_CurrCtrlCombo;
    }

    public int getCurrSqi() {
        return this.m_nCurrSqi;
    }

    public boolean getLowOrderVCATEnabled() {
        return this.m_bLoVCat;
    }

    public String getNewCtrl() {
        return this.m_sNewCtrl;
    }

    public MaskedIntegerValue getNewCtrlCombo() {
        return this.m_NewCtrlCombo;
    }

    public String getNewSqi() {
        return this.m_sNewSqi;
    }

    public boolean InContext() {
        return this.m_bInContext;
    }

    public void serialize(PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        primitiveTypesWriter.write(this.m_bInContext);
        primitiveTypesWriter.write(this.m_bLoVCat);
        primitiveTypesWriter.write(this.m_channelPos);
        primitiveTypesWriter.write(this.m_nCurrSqi);
        primitiveTypesWriter.write(this.m_sCurrCtrl);
        primitiveTypesWriter.write(this.m_CurrCtrlCombo.getValue());
        primitiveTypesWriter.write(this.m_CurrCtrlCombo.getOptionMask().getValue());
        primitiveTypesWriter.write(this.m_CurrCtrlCombo.getStateMask().getValue());
        primitiveTypesWriter.write(this.m_NewCtrlCombo.getValue());
        primitiveTypesWriter.write(this.m_NewCtrlCombo.getOptionMask().getValue());
        primitiveTypesWriter.write(this.m_NewCtrlCombo.getStateMask().getValue());
        primitiveTypesWriter.write(this.m_sNewSqi);
        primitiveTypesWriter.write(this.m_sNewCtrl);
    }

    public void setChannelPos(int n) {
        this.m_channelPos = n;
    }

    public void setContext(boolean bl) {
        this.m_bInContext = bl;
    }

    public void setCurrCtrl(String string) {
        this.m_sCurrCtrl = string;
    }

    public void setCurrCtrlCombo(MaskedIntegerValue maskedIntegerValue) {
        this.m_CurrCtrlCombo = maskedIntegerValue;
    }

    public void setCurrSqi(byte by) {
        this.m_nCurrSqi = by;
    }

    public void setCurrSqi(int n) {
        this.m_nCurrSqi = n;
    }

    public void setNewCtrl(String string) {
        this.m_sNewCtrl = string;
    }

    public void setNewCtrlCombo(MaskedIntegerValue maskedIntegerValue) {
        this.m_NewCtrlCombo = maskedIntegerValue;
    }

    public void setNewSqi(String string) {
        this.m_sNewSqi = string;
    }
}

