/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.results.usercode;

import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.AppSerializable;
import java.io.IOException;

public class TroubleScanData
implements AppSerializable {
    private boolean alarmsActive;
    private boolean alarmHistory;
    private int maxErrors;
    private String[] names;
    private String[] values;
    private int errorCount;

    public TroubleScanData(int n) {
        this.maxErrors = n;
        this.names = new String[this.maxErrors];
        this.values = new String[this.maxErrors];
    }

    public int activeErrorCount() {
        return this.errorCount;
    }

    public boolean alarmHistory() {
        return this.alarmHistory;
    }

    public boolean alarmsActive() {
        return this.alarmsActive;
    }

    public void deserialize(PrimitiveTypesReader primitiveTypesReader) throws IOException {
        this.alarmsActive = primitiveTypesReader.readBoolean();
        this.alarmHistory = primitiveTypesReader.readBoolean();
        this.errorCount = primitiveTypesReader.readShort();
        int n = 0;
        while (n < this.errorCount) {
            this.names[n] = primitiveTypesReader.readString();
            this.values[n] = primitiveTypesReader.readString();
            ++n;
        }
        n = this.errorCount;
        while (n < this.maxErrors) {
            this.names[n] = null;
            this.values[n] = null;
            ++n;
        }
    }

    public boolean equals(TroubleScanData troubleScanData) {
        if (this.alarmsActive != troubleScanData.alarmsActive || this.alarmHistory != troubleScanData.alarmHistory || this.errorCount != troubleScanData.errorCount) {
            return false;
        }
        int n = 0;
        while (n < this.errorCount) {
            if (!this.names[n].equals(troubleScanData.names[n]) || !this.values[n].equals(troubleScanData.values[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof TroubleScanData && object != null) {
            return this.equals((TroubleScanData)object);
        }
        return false;
    }

    public String getName(int n) {
        return this.names[n];
    }

    public String getValue(int n) {
        return this.values[n];
    }

    public boolean noErrors() {
        return this.errorCount == 0;
    }

    public void serialize(PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
    }
}

