/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.results.usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.IndexPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.lynx.results.usercode.ResultNameMapper;
import com.agilent.tntd.lynx.results.usercode.TroubleScanData;
import java.io.IOException;

public class TroubleScanReader
extends GenericDataReader {
    private static final int ALARMS_DETECTED_PANE = 101;
    private static final int TROUBLE_SCAN_PANE = 100;
    private static final int ERROR_NAME_BASE = 10;
    private static final int ERROR_VALUE_BASE = 20;
    private static final int SDH = 0;
    private static final int SONET = 1;
    private static final int NO_TROUBLE = 0;
    private static final int NO_ALARMS = 1;
    private static final int ALARM_HISTORY = 2;
    private static final int ALARMS_DETECTED = 3;
    private static final int ERRORS = 1;
    private int maxErrors;
    private boolean dataReady;
    private TroubleScanData tsData;
    private TroubleScanData previousTsData;
    private int standard;
    private int previousStandard;
    private ResultNameMapper theMapper;
    private boolean alarmsPaneChanged;
    private boolean errorsPaneChanged;
    private boolean[] namesChanged;
    private boolean[] valuesChanged;

    public TroubleScanReader() {
        this(4);
    }

    public TroubleScanReader(int n) {
        if (this.maxErrors > 10) {
            throw new IllegalArgumentException();
        }
        this.maxErrors = n;
        this.tsData = new TroubleScanData(this.maxErrors);
        this.previousTsData = new TroubleScanData(this.maxErrors);
        this.theMapper = ResultNameMapper.instance();
        this.namesChanged = new boolean[this.maxErrors];
        this.valuesChanged = new boolean[this.maxErrors];
    }

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        try {
            TroubleScanData troubleScanData = this.tsData;
            this.tsData = this.previousTsData;
            this.previousTsData = troubleScanData;
            int n = this.standard;
            this.standard = this.previousStandard;
            this.previousStandard = n;
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            this.standard = primitiveTypesReader.readByte();
            this.tsData.deserialize(primitiveTypesReader);
            this.setRepaintFlags();
            this.dataReady = true;
        }
        catch (IOException iOException) {
            this.dataReady = false;
        }
        return true;
    }

    private boolean isErrorID(int n) {
        return n >= 0 && n < 10;
    }

    private boolean repaintRequired(int n) {
        if (this.isErrorID(n - 10)) {
            if (this.standard == this.previousStandard) {
                return this.namesChanged[n - 10];
            }
            return true;
        }
        if (this.isErrorID(n - 20)) {
            return this.valuesChanged[n - 20];
        }
        if (n == 100) {
            return this.errorsPaneChanged;
        }
        if (n == 101) {
            return this.alarmsPaneChanged;
        }
        return true;
    }

    private boolean setAlarmsDetectedPane(PropertyAccessor propertyAccessor) {
        boolean bl = false;
        try {
            bl = this.tsData.alarmsActive() ? ((IndexPropertyAccessor)propertyAccessor).setIndexProperty(3) : (this.tsData.alarmHistory() ? ((IndexPropertyAccessor)propertyAccessor).setIndexProperty(2) : (this.tsData.activeErrorCount() != 0 ? ((IndexPropertyAccessor)propertyAccessor).setIndexProperty(1) : ((IndexPropertyAccessor)propertyAccessor).setIndexProperty(0)));
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        return bl;
    }

    private boolean setErrorName(int n, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        try {
            bl = this.tsData.activeErrorCount() > n ? ((TextPropertyAccessor)propertyAccessor).setTextProperty(this.theMapper.getMapping(this.tsData.getName(n), this.standard)) : ((TextPropertyAccessor)propertyAccessor).setTextProperty("");
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        return bl;
    }

    private boolean setErrorValue(int n, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        try {
            bl = this.tsData.activeErrorCount() > n ? ((TextPropertyAccessor)propertyAccessor).setTextProperty(this.tsData.getValue(n)) : ((TextPropertyAccessor)propertyAccessor).setTextProperty("");
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        return bl;
    }

    private void setRepaintFlags() {
        this.alarmsPaneChanged = this.tsData.alarmsActive() != this.previousTsData.alarmsActive() || this.tsData.alarmHistory() != this.previousTsData.alarmHistory() || this.tsData.noErrors() != this.previousTsData.noErrors();
        this.errorsPaneChanged = this.tsData.noErrors() != this.previousTsData.noErrors();
        int n = 0;
        while (n < this.tsData.activeErrorCount()) {
            this.namesChanged[n] = !this.tsData.getName(n).equals(this.previousTsData.getName(n));
            this.valuesChanged[n] = !this.tsData.getValue(n).equals(this.previousTsData.getValue(n));
            ++n;
        }
        n = this.tsData.activeErrorCount();
        while (n < this.previousTsData.activeErrorCount()) {
            this.namesChanged[n] = true;
            this.valuesChanged[n] = true;
            ++n;
        }
    }

    private boolean setTroubleScanPane(PropertyAccessor propertyAccessor) {
        boolean bl = false;
        try {
            bl = !this.tsData.noErrors() ? ((IndexPropertyAccessor)propertyAccessor).setIndexProperty(1) : ((IndexPropertyAccessor)propertyAccessor).setIndexProperty(0);
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        return bl;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = this.dataReady;
        if (this.dataReady && (bl || this.repaintRequired(n))) {
            if (this.isErrorID(n - 10)) {
                bl2 = this.setErrorName(n - 10, propertyAccessor);
            } else if (this.isErrorID(n - 20)) {
                bl2 = this.setErrorValue(n - 20, propertyAccessor);
            } else if (n == 100) {
                bl2 = this.setTroubleScanPane(propertyAccessor);
            } else if (n == 101) {
                bl2 = this.setAlarmsDetectedPane(propertyAccessor);
            }
            propertyAccessor.repaint();
        }
        return bl2;
    }
}

