/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.results.vcat_overview;

import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclLedDefaults;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.BasicLabel;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.Tiler;
import com.agilent.tntd.eclipse.viewlayer.components.led.EclLed;
import com.agilent.tntd.eclipse.viewlayer.components.led.EclLedModel;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.EclToggleButton;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.EclDialog;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindow;
import com.agilent.tntd.lynx.results.vcat_overview.VCatOverview;
import com.agilent.tntd.lynx.results.vcat_overview.VCatOverviewObserver;
import com.agilent.tntd.lynx.results.vcat_overview.VCatOverviewServerProxy;
import com.agilent.tntd.lynx.txrx.mixedbackground.DBconnection;
import com.agilent.tntd.lynx.txrx.mixedbackground.MapWizDirector;
import com.agilent.tntd.lynx.txrx.mixedbackground.MapWizTile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;

public class VCatOverviewDirector
extends MapWizDirector
implements VCatOverviewObserver {
    private VCatOverview fieldMapWizWindow = null;
    private Tiler fieldLedTiler = new Tiler();
    private Tiler fieldMappingTiler = new Tiler();
    public VCatOverviewServerProxy m_clientServer = null;
    protected String m_clientName;
    private static final int m_maxLeds = 192;
    private static final int m_expBytes = 48;
    private byte[] m_tileColours = new byte[48];
    private static final int m_divideTU12 = 4;
    private static final int m_divideTU11 = 3;
    private static final int m_divideTU3 = 2;
    private static final int m_noColour = 0;
    private static final int m_amberColour = 1;
    private static final int m_redColour = 2;
    private DBconnection m_sigStd = null;
    private DBconnection m_mappingIsTU12 = null;
    private DBconnection m_mappingIsTU11 = null;
    private DBconnection m_mappingIsTU3 = null;
    private DBconnection m_mappingIsLCAS = null;
    private DBconnection m_rateIs10g = null;
    private DBconnection m_rateIsLCAS10g = null;
    private DBconnection m_rateIs10gHO = null;

    public VCatOverviewDirector() {
        super.setDatabaseVariables(1);
        this.m_sigStd = new DBconnection(this, "RX_SIGNAL_STD", 0);
        this.m_mappingIsTU12 = new DBconnection(this, "RX_MAPPING_VT_TU_IS_2M3", 0);
        this.m_mappingIsTU11 = new DBconnection(this, "RX_MAPPING_VT_TU_IS_1M7", 0);
        this.m_mappingIsTU3 = new DBconnection(this, "RX_MAPPING_TU_IS_TU3", 0);
        this.m_mappingIsLCAS = new DBconnection(this, "RX_MAPPING_LCAS", 0);
        this.m_rateIs10g = new DBconnection(this, "RX_VCAT_10G_GCON", 0);
        this.m_rateIsLCAS10g = new DBconnection(this, "RX_VCAT_LCAS_10G_GCON", 0);
        this.m_rateIs10gHO = new DBconnection(this, "RX_VCAT_10G_HO_GCON", 0);
        this.m_clientName = "VCAT_OVERVIEW";
        if (this.m_clientServer == null) {
            this.m_clientServer = new VCatOverviewServerProxy(this.m_clientName, this);
        }
    }

    private void addLed(EclLed eclLed, Container container) {
        container.add((Component)eclLed);
    }

    private void connectLeds() {
        int n = 0;
        while (n < this.getLedTiler().getComponentCount()) {
            EclLed eclLed = (EclLed)this.getLedTiler().getComponent(n);
            eclLed.finishInitialise();
            ++n;
        }
    }

    public void finishIntialise() {
        this.m_clientServer.register();
    }

    public BasicLabel getCurrChanLabel() {
        return ((VCatOverview)this.getMapwizWindow()).getCurrChanLabel();
    }

    public EclToggleButton getExitButton() {
        return new EclToggleButton();
    }

    public Tiler getLedTiler() {
        return this.fieldLedTiler;
    }

    public EclWindow getMapwizWindow() {
        return this.fieldMapWizWindow;
    }

    private Color GetTileColour(int n) {
        Color color;
        switch (n) {
            case 0: {
                color = null;
                break;
            }
            case 1: {
                color = EclLedDefaults.amberColour;
                break;
            }
            case 2: {
                color = EclLedDefaults.redColour;
                break;
            }
            default: {
                color = null;
            }
        }
        return color;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        MapWizTile mapWizTile = null;
        if (itemEvent.getStateChange() == 1 && itemEvent.getItem() != null) {
            Object object;
            mapWizTile = (MapWizTile)((Object)itemEvent.getItem());
            int n = mapWizTile.getSQI();
            int n2 = 0;
            while (n2 < this.getLedTiler().getComponentCount()) {
                object = (EclLed)this.getLedTiler().getComponent(n2);
                object.unregister();
                ++n2;
            }
            this.getLedTiler().removeAll();
            String string = "...";
            this.getCurrChanLabel().setText(string);
            object = (VCatOverview)this.getMapwizWindow();
            ((VCatOverview)((Object)object)).getOOM1MemLabel().setText("");
            ((VCatOverview)((Object)object)).getOOM2MemLabel().setText("");
            ((VCatOverview)((Object)object)).getLOMMemLabel().setText("");
            ((VCatOverview)((Object)object)).getSQMMemLabel().setText("");
            ((VCatOverview)((Object)object)).getLOPMemLabel().setText("");
            ((VCatOverview)((Object)object)).getAUAISMemLabel().setText("");
            ((VCatOverview)((Object)object)).getHPRDIMemLabel().setText("");
            ((VCatOverview)((Object)object)).getLPRFIMemLabel().setText("");
            ((VCatOverview)((Object)object)).getB3BIPMemLabel().setText("");
            ((VCatOverview)((Object)object)).getHPREIMemLabel().setText("");
            ((VCatOverview)((Object)object)).getCRCMemLabel().setText("");
            if (mapWizTile.getTileState() != 0 && mapWizTile.getTileState() != 4) {
                int n3 = 1;
                String string2 = "TU";
                String string3 = "TU";
                String string4 = "LP";
                String string5 = "V";
                if (this.m_mappingIsTU12.getDBValue() == 1) {
                    n3 = 4;
                } else if (this.m_mappingIsTU11.getDBValue() == 1) {
                    n3 = 3;
                } else if (this.m_mappingIsTU3.getDBValue() == 1) {
                    n3 = 2;
                } else {
                    string2 = "AU";
                    string3 = "B3";
                    string4 = "HP";
                    string5 = "P";
                }
                if (this.m_rateIs10g.getDBValue() == 1) {
                    ((VCatOverview)((Object)object)).getLOPMemLabel().setEnabled(true);
                    ((VCatOverview)((Object)object)).getAUAISMemLabel().setEnabled(true);
                    ((VCatOverview)((Object)object)).getHPRDIMemLabel().setEnabled(true);
                    ((VCatOverview)((Object)object)).getB3BIPMemLabel().setEnabled(true);
                    ((VCatOverview)((Object)object)).getHPREIMemLabel().setEnabled(true);
                } else {
                    ((VCatOverview)((Object)object)).getLOPMemLabel().setEnabled(false);
                    ((VCatOverview)((Object)object)).getAUAISMemLabel().setEnabled(false);
                    ((VCatOverview)((Object)object)).getHPRDIMemLabel().setEnabled(false);
                    ((VCatOverview)((Object)object)).getB3BIPMemLabel().setEnabled(false);
                    ((VCatOverview)((Object)object)).getHPREIMemLabel().setEnabled(false);
                }
                if (this.m_rateIs10gHO.getDBValue() == 1) {
                    ((VCatOverview)((Object)object)).getLPRFIMemLabel().setEnabled(true);
                } else {
                    ((VCatOverview)((Object)object)).getLPRFIMemLabel().setEnabled(false);
                }
                if (this.m_rateIsLCAS10g.getDBValue() == 1) {
                    ((VCatOverview)((Object)object)).getCRCMemLabel().setEnabled(true);
                } else {
                    ((VCatOverview)((Object)object)).getCRCMemLabel().setEnabled(false);
                }
                int n4 = mapWizTile.getStart();
                string = "" + n;
                this.getCurrChanLabel().setText(string);
                string = "SW_LED_VCAT_OOM1_" + (n4 /= n3) + "_HY_DISP";
                EclLed eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 1, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                string = "SW_LED_VCAT_OOM1_" + n4 + "_CT_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 0, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                ((VCatOverview)((Object)object)).getOOM1MemLabel().setText("OOM1");
                string = "SW_LED_VCAT_OOM2_" + n4 + "_HY_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 1, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                string = "SW_LED_VCAT_OOM2_" + n4 + "_CT_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 0, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                ((VCatOverview)((Object)object)).getOOM2MemLabel().setText("OOM2");
                string = "SW_LED_VCAT_LOM_" + n4 + "_HY_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 1, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                string = "SW_LED_VCAT_LOM_" + n4 + "_CT_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 0, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                ((VCatOverview)((Object)object)).getLOMMemLabel().setText("LOM");
                string = "SW_LED_VCAT_SQM_" + n4 + "_HY_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 1, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                string = "SW_LED_VCAT_SQM_" + n4 + "_CT_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 0, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                if (this.m_mappingIsLCAS.getDBValue() == 0) {
                    ((VCatOverview)((Object)object)).getSQMMemLabel().setText("SQM");
                } else {
                    ((VCatOverview)((Object)object)).getSQMMemLabel().setText("GID mismatch");
                }
                string = "SW_LED_VCAT_LOP_" + n4 + "_HY_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 1, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                string = "SW_LED_VCAT_LOP_" + n4 + "_CT_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 0, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                if (this.m_sigStd.getDBValue() == 1) {
                    ((VCatOverview)((Object)object)).getLOPMemLabel().setText("LOP-" + string5);
                } else {
                    ((VCatOverview)((Object)object)).getLOPMemLabel().setText(String.valueOf(string2) + "-LOP");
                }
                string = "SW_LED_VCAT_AUAIS_" + n4 + "_HY_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 1, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                string = "SW_LED_VCAT_AUAIS_" + n4 + "_CT_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 0, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                if (this.m_sigStd.getDBValue() == 1) {
                    ((VCatOverview)((Object)object)).getAUAISMemLabel().setText("AIS-" + string5);
                } else {
                    ((VCatOverview)((Object)object)).getAUAISMemLabel().setText(String.valueOf(string2) + "-AIS");
                }
                string = "SW_LED_VCAT_HPRDI_" + n4 + "_HY_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 1, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                string = "SW_LED_VCAT_HPRDI_" + n4 + "_CT_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 0, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                if (this.m_sigStd.getDBValue() == 1) {
                    ((VCatOverview)((Object)object)).getHPRDIMemLabel().setText("RDI-" + string5);
                } else {
                    ((VCatOverview)((Object)object)).getHPRDIMemLabel().setText(String.valueOf(string4) + "-RDI");
                }
                string = n4 < 84 ? "SW_LED_VCAT_LPRFI_" + n4 + "_HY_DISP" : "SW_LED_VCAT_DUMMY_HY_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 1, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                string = n4 < 84 ? "SW_LED_VCAT_LPRFI_" + n4 + "_CT_DISP" : "SW_LED_VCAT_DUMMY_CT_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 0, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                if (this.m_sigStd.getDBValue() == 1) {
                    ((VCatOverview)((Object)object)).getLPRFIMemLabel().setText("RFI-V");
                } else {
                    ((VCatOverview)((Object)object)).getLPRFIMemLabel().setText("LP-RFI");
                }
                string = "SW_LED_VCAT_B3BIP_" + n4 + "_HY_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 1, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                string = "SW_LED_VCAT_B3BIP_" + n4 + "_CT_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 0, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                if (this.m_sigStd.getDBValue() == 1) {
                    ((VCatOverview)((Object)object)).getB3BIPMemLabel().setText("CV-" + string5);
                } else {
                    ((VCatOverview)((Object)object)).getB3BIPMemLabel().setText(String.valueOf(string3) + "-BIP");
                }
                string = "SW_LED_VCAT_HPREI_" + n4 + "_HY_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 1, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                string = "SW_LED_VCAT_HPREI_" + n4 + "_CT_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 0, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                if (this.m_sigStd.getDBValue() == 1) {
                    ((VCatOverview)((Object)object)).getHPREIMemLabel().setText("REI-" + string5);
                } else {
                    ((VCatOverview)((Object)object)).getHPREIMemLabel().setText(String.valueOf(string4) + "-REI");
                }
                string = "SW_LED_VCAT_CRC_" + n4 + "_HY_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 1, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                string = "SW_LED_VCAT_CRC_" + n4 + "_CT_DISP";
                eclLed = new EclLed();
                eclLed.setEclModel(new EclLedModel(string, 0, 12));
                this.addLed(eclLed, (Container)this.getLedTiler());
                ((VCatOverview)((Object)object)).getCRCMemLabel().setText("LCAS CRC");
                this.connectLeds();
            }
        }
    }

    private int PowerOf(int n, int n2) {
        int n3 = 1;
        int n4 = 0;
        while (n4 < n2) {
            n3 *= n;
            ++n4;
        }
        return n3;
    }

    public void refreshOverview(int n, byte[] byArray) {
        if (n == 48) {
            int n2 = 1;
            if (this.m_mappingIsTU12.getDBValue() == 1) {
                n2 = 4;
            } else if (this.m_mappingIsTU11.getDBValue() == 1) {
                n2 = 3;
            } else if (this.m_mappingIsTU3.getDBValue() == 1) {
                n2 = 2;
            }
            this.m_tileColours = byArray;
            Component[] componentArray = ((Container)((Object)this.theTiler)).getComponents();
            int n3 = 0;
            while (n3 < componentArray.length) {
                MapWizTile mapWizTile = (MapWizTile)((Object)componentArray[n3]);
                mapWizTile.getSQI();
                if (mapWizTile.getTileState() != 0 && mapWizTile.getTileState() != 4) {
                    int n4;
                    int n5;
                    int n6;
                    Color color;
                    int n7 = mapWizTile.getStart();
                    int n8 = (n7 /= n2) / 4;
                    if ((color = this.GetTileColour(n6 = (byArray[n8] & (n5 = 192 / this.PowerOf(4, n4 = n7 % 4))) >> 6 - n4 * 2)) != null) {
                        ((Component)((Object)mapWizTile)).setBackground(color);
                    } else {
                        this.setBkColor(mapWizTile, mapWizTile.isFgTile(), (short)mapWizTile.getTileState());
                    }
                }
                ++n3;
            }
            this.theTiler.repaint();
        }
    }

    public void refreshSegment(short s, short s2, short s3, short s4, short s5, short s6, short s7, short[] sArray, short[] sArray2, short[] sArray3) {
        super.refreshSegment(s, s2, s3, s4, s5, s6, s7, sArray, sArray2, sArray3);
        this.m_clientServer.queryLeds();
    }

    public void setLedTiler(Tiler tiler) {
        this.fieldLedTiler = tiler;
    }

    public void setMapwizWindow(EclWindow eclWindow) {
        this.fieldMapWizWindow = (VCatOverview)eclWindow;
    }

    public void showError(short s) {
        EclDialog eclDialog = new EclDialog();
        eclDialog.setSize(328, 186);
        switch (s) {
            default: 
        }
        System.out.println("Unknown Error Code Received!");
    }

    public void unregister() {
        super.unregister();
        this.m_clientServer.unregister();
    }

    public void VCatOverviewDirectorSetup_HO_LO(VCatOverview vCatOverview, int n) {
        if (n == 1) {
            this.mapWizClientName = "RX_MAPWIZ_TU";
            this.bLoDisplay = true;
        } else {
            this.mapWizClientName = "RX_MAPWIZ_AU";
            this.bLoDisplay = false;
        }
    }
}

