/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.results.vcat_overview;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.lynx.results.vcat_overview.VCatOverviewObserver;
import java.io.IOException;

public class VCatOverviewServerProxy
implements CcConnectedComponent,
ApplicationGenericDataReceiver {
    private String variableName = null;
    private ApplicationObject ao = null;
    private VCatOverviewObserver observer = null;

    public VCatOverviewServerProxy(String string, VCatOverviewObserver vCatOverviewObserver) {
        this.variableName = string;
        this.observer = vCatOverviewObserver;
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        switch (errorReporter.getErrorStatus()) {
            case 1: {
                EventLog.instance().log("Could not establish connection to server: " + applicationObject.toString() + " failed to initialise");
                this.ao = null;
                break;
            }
            case 3: {
                EventLog.instance().log("Could not establish connection to server: " + applicationObject.toString() + " requested from unknown domain");
                this.ao = null;
                break;
            }
            case 0: 
            case 2: {
                if (!applicationObject.getName().equals(this.variableName)) break;
                this.ao = applicationObject;
            }
        }
    }

    public void finishInitialise() {
        ApplicationManager.instance().request("ISS", 0, this.variableName, (ApplicationObjectObserver)this);
    }

    public void queryEntireStructure() {
        this.querySegment((short)0, (short)-1);
    }

    public void queryLeds() {
        ApplicationGenericMetaData applicationGenericMetaData = new ApplicationGenericMetaData();
        applicationGenericMetaData.getPrimitiveTypesWriter();
        applicationGenericMetaData.completedMetaDataInitialisation();
        this.ao.asyncQuery((ApplicationMetaData)applicationGenericMetaData, (ApplicationObjectObserver)this);
    }

    public void querySegment(short s, short s2) {
        try {
            ApplicationGenericMetaData applicationGenericMetaData = new ApplicationGenericMetaData();
            PrimitiveTypesWriter primitiveTypesWriter = applicationGenericMetaData.getPrimitiveTypesWriter();
            primitiveTypesWriter.write(s);
            primitiveTypesWriter.write(s2);
            applicationGenericMetaData.completedMetaDataInitialisation();
            this.ao.asyncQuery((ApplicationMetaData)applicationGenericMetaData, (ApplicationObjectObserver)this);
        }
        catch (IOException iOException) {
            EventLog.instance().log("IOException attempting to write to " + this.variableName);
        }
    }

    public void receiveApplicationGenericData(ApplicationGenericData applicationGenericData, ApplicationDataSender applicationDataSender) {
        PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
        try {
            int n = primitiveTypesReader.readShort();
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = primitiveTypesReader.readByte();
                ++n2;
            }
            if (this.observer != null) {
                this.observer.refreshOverview(n, byArray);
            }
        }
        catch (IOException iOException) {
            EventLog.instance().log("IOException reading from " + this.variableName);
        }
    }

    public void register() {
        this.finishInitialise();
    }

    public void trapTransientError(boolean bl) {
    }

    public void unregister() {
        if (this.ao != null) {
            this.ao.unregister((ApplicationObjectObserver)this);
        }
        this.ao = null;
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            if (applicationData != null) {
                applicationData.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)applicationObject);
            } else {
                this.queryEntireStructure();
            }
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log("ServerConnection cannot receive " + applicationData.toString() + " from " + applicationObject.toString());
        }
    }
}

