/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.tstfunc_usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.IndexPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.LockableBooleanPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.datatype.LockableBoolean;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import com.agilent.tntd.lynx.overhead_usercode.CompositeReaderSupport;
import com.agilent.tntd.lynx.tstfunc_usercode.VCatDelayData;
import com.agilent.tntd.lynx.txrx.mixedbackground.DBconnection;
import com.agilent.tntd.lynx.txrx.mixedbackground.TelecomsHelper;
import java.io.IOException;

public abstract class AVCatDelayDataReader
extends GenericDataReader
implements MaskedIntegerDataReceiver {
    private int m_numElements;
    protected VCatDelayData[] m_vcatDelayData;
    protected VCatDelayData[] m_prevVcatDelayData;
    protected boolean m_dataReady;
    private static final int CHANNEL_ID = 0;
    private static final int SQI_ID = 1;
    private static final int INCREMENT_ENABLED_ID = 3;
    private static final int REQ_MS_DELAY_ID = 4;
    private static final int ACT_MS_DELAY_ID = 5;
    private static final int m_componentsPerObject = 10;
    private static final int PROTO_WRITE_DELAY_ENABLED = 0;
    private static final int PROTO_WRITE_ADJUSTMENT_ENABLED = 1;
    private static final int PROTO_WRITE_MS_DELAY = 2;
    protected boolean[] m_repaintRequired;
    protected CompositeReaderSupport m_support;
    protected DBconnection signalMode = null;
    protected DBconnection signalRate = null;
    protected DBconnection signalMapping = null;
    protected DBconnection signalMappingTu = null;
    protected int m_nChannelSize = 0;

    public AVCatDelayDataReader(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.m_numElements = n;
        this.m_vcatDelayData = new VCatDelayData[this.m_numElements];
        this.m_prevVcatDelayData = new VCatDelayData[this.m_numElements];
        int n2 = 0;
        while (n2 < this.m_vcatDelayData.length) {
            this.m_vcatDelayData[n2] = new VCatDelayData();
            this.m_prevVcatDelayData[n2] = new VCatDelayData();
            ++n2;
        }
        this.m_repaintRequired = new boolean[this.m_numElements];
        this.m_support = new CompositeReaderSupport(this.m_numElements);
    }

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        TelecomsHelper.setMode(this.signalMode.getDBValue());
        TelecomsHelper.setRate(this.signalRate.getDBValue());
        this.m_nChannelSize = 1;
        if (this.signalMappingTu.getDBValue() == 0) {
            if (this.signalMapping.getDBValue() == 6) {
                this.m_nChannelSize = 3;
            }
        } else {
            switch (this.signalMappingTu.getDBValue()) {
                case 1: {
                    this.m_nChannelSize = 2;
                    break;
                }
                case 2: {
                    this.m_nChannelSize = 4;
                    break;
                }
                default: {
                    this.m_nChannelSize = 3;
                }
            }
        }
        try {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            this.m_support.deserialize(primitiveTypesReader, this.m_vcatDelayData, this.m_prevVcatDelayData, this.m_repaintRequired);
            this.m_dataReady = true;
        }
        catch (IOException iOException) {
            this.m_dataReady = false;
        }
        return true;
    }

    private String getHistory(int n) {
        return ",  ,  ,  ,  ";
    }

    private int getNumElements() {
        return this.m_numElements;
    }

    public ApplicationData modifyDataToChange(ApplicationData applicationData) {
        ApplicationData applicationData2 = applicationData;
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            int n = this.m_support.getChangeCompositeID(applicationData);
            int n2 = n / 10;
            this.m_support.writeChangeIndex(n2, (PrimitiveTypesWriter)simpleTypesWriter);
            switch (n % 10) {
                case 3: {
                    simpleTypesWriter.write(1);
                    simpleTypesWriter.write(((MaskedIntegerValue)applicationData).getValue() == 1);
                    break;
                }
                case 4: {
                    simpleTypesWriter.write(2);
                    simpleTypesWriter.write(((KnownLengthStringValue)applicationData).getValue());
                    break;
                }
            }
            applicationData2 = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
        }
        catch (IOException iOException) {
            EventLog.instance().log("Could not read the meta data from this ecldataentry, or write the data to send to the server.");
        }
        catch (ClassCastException classCastException) {
            EventLog.instance().log("VCatDelayDataReader - unexpected application data type was received! ");
        }
        return applicationData2;
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
    }

    private boolean setAsciiTextProperty(int n, int n2, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        if (!(propertyAccessor instanceof TextPropertyAccessor)) {
            return true;
        }
        VCatDelayData vCatDelayData = this.m_vcatDelayData[n];
        switch (n2) {
            case 0: {
                String string = vCatDelayData.InContext() ? "[" + TelecomsHelper.getStartPosn(vCatDelayData.getChannelPos(), this.m_nChannelSize, vCatDelayData.getLowOrderVCATEnabled()) + "]" : "...";
                bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 1: {
                String string = vCatDelayData.InContext() ? Integer.toString(vCatDelayData.getSqi()) : "...";
                bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 4: {
                bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(vCatDelayData.getMsDelay());
                break;
            }
            case 5: {
                if (Float.valueOf(vCatDelayData.getActualMsDelay()).intValue() < 0) {
                    bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty("...");
                    break;
                }
                bl = ((TextPropertyAccessor)propertyAccessor).setTextProperty(vCatDelayData.getActualMsDelay());
                break;
            }
        }
        return bl;
    }

    private boolean setBoolProperty(int n, int n2, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        VCatDelayData vCatDelayData = this.m_vcatDelayData[n];
        if (!vCatDelayData.InContext()) {
            return true;
        }
        if (n2 == 3 && propertyAccessor instanceof LockableBooleanPropertyAccessor) {
            bl = ((LockableBooleanPropertyAccessor)propertyAccessor).setLockableBooleanProperty(new LockableBoolean(vCatDelayData.getIncrementEnabled()));
        }
        return bl;
    }

    private boolean setComboProperties(int n, PropertyAccessor propertyAccessor) {
        boolean bl = false;
        VCatDelayData vCatDelayData = this.m_vcatDelayData[n];
        if (propertyAccessor instanceof IndexPropertyAccessor) {
            int n2 = vCatDelayData.InContext() ? 1 : 0;
            bl = ((IndexPropertyAccessor)propertyAccessor).setIndexProperty(n2);
            propertyAccessor.repaint();
        }
        return bl;
    }

    private boolean setGreyingProperty(int n, int n2, PropertyAccessor propertyAccessor) {
        boolean bl = true;
        VCatDelayData cfr_ignored_0 = this.m_vcatDelayData[n];
        boolean cfr_ignored_1 = propertyAccessor instanceof GreyPropertyAccessor;
        return bl;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = this.m_dataReady;
        int n2 = n / 10;
        if (this.m_dataReady) {
            int n3 = n % 10;
            switch (n3) {
                case 3: {
                    bl2 = this.setBoolProperty(n2, n3, propertyAccessor) && this.setGreyingProperty(n2, n3, propertyAccessor);
                    propertyAccessor.repaint();
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 5: {
                    bl2 = this.setAsciiTextProperty(n2, n3, propertyAccessor) && this.setGreyingProperty(n2, n3, propertyAccessor);
                    propertyAccessor.repaint();
                    break;
                }
            }
        }
        return bl2;
    }

    private void writeNewAsciiByteData(int n, String string, PrimitiveTypesWriter primitiveTypesWriter) throws IOException {
        int n2 = Integer.parseInt(string, 10);
        primitiveTypesWriter.write((short)n2);
    }
}

