/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.tstfunc_usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.LockableBooleanPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.MaskedIntegerPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.datatype.LockableBoolean;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import java.io.IOException;

public class EncapAnalyByteTriggerDebugReader
extends GenericDataReader {
    private static final int HWID_COMPOSITE_DATA_ID = 1;
    private static final int ENABLE_COMPOSITE_DATA_ID = 2;
    private static final int POLARITY_COMPOSITE_DATA_ID = 3;
    private static final int VALUE_COMPOSITE_DATA_ID = 4;
    private static final int MASK_COMPOSITE_DATA_ID = 5;
    private static final int BYTEOFFSET_COMPOSITE_DATA_ID = 6;
    private static final int BITOFFSET_COMPOSITE_DATA_ID = 7;
    private static final int GROUPID_COMPOSITE_DATA_ID = 8;
    private static final int USER_COMPOSITE_DATA_ID = 9;
    byte m_hwId;
    boolean m_enable;
    int m_polarity;
    byte m_value;
    byte m_mask;
    long m_byteOffset;
    long m_bitOffset;
    byte m_groupId;
    String m_ownerName;
    boolean m_dataReady;

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        try {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            this.m_hwId = primitiveTypesReader.readByte();
            this.m_enable = primitiveTypesReader.readBoolean();
            boolean bl = primitiveTypesReader.readBoolean();
            this.m_polarity = bl ? 1 : 0;
            this.m_value = primitiveTypesReader.readByte();
            this.m_mask = primitiveTypesReader.readByte();
            this.m_byteOffset = primitiveTypesReader.readLong();
            this.m_bitOffset = primitiveTypesReader.readLong();
            this.m_groupId = primitiveTypesReader.readByte();
            this.m_ownerName = "";
            int n = primitiveTypesReader.readInt();
            if (n != 0) {
                byte[] byArray = new byte[n];
                int n2 = 0;
                while (n2 < n) {
                    byArray[n2] = primitiveTypesReader.readByte();
                    ++n2;
                }
                String string = new String(byArray, 0, n);
                int n3 = string.lastIndexOf("FIELD_VAL");
                if (n3 != -1) {
                    string = string.substring(n3 + 10).toLowerCase();
                }
                this.m_ownerName = string;
            }
            this.m_dataReady = true;
        }
        catch (IOException iOException) {
            this.m_dataReady = false;
        }
        return true;
    }

    private String convertLongToHexString(long l, int n) {
        String string = Long.toHexString(l).toUpperCase();
        while (string.length() < n) {
            string = "0" + string;
        }
        if (string.length() > n) {
            string = string.substring(string.length() - n, string.length());
        }
        return string;
    }

    public int getChangeCompositeID(ApplicationData applicationData) throws IOException {
        ApplicationGenericMetaData applicationGenericMetaData = (ApplicationGenericMetaData)applicationData.description();
        SimpleTypesReader simpleTypesReader = new SimpleTypesReader();
        simpleTypesReader.initialiseByteArrayToRead(applicationGenericMetaData.getByteArray());
        int n = simpleTypesReader.readInt();
        return n;
    }

    public ApplicationData modifyDataToChange(ApplicationData applicationData) {
        ApplicationData applicationData2 = applicationData;
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            int n = this.getChangeCompositeID(applicationData);
            simpleTypesWriter.write(n);
            switch (n) {
                case 2: {
                    int n2 = ((MaskedIntegerValue)applicationData).getValue();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    simpleTypesWriter.write(bl);
                    break;
                }
                case 3: {
                    int n3 = ((MaskedIntegerValue)applicationData).getValue();
                    boolean bl = false;
                    if (n3 != 0) {
                        bl = true;
                    }
                    simpleTypesWriter.write(bl);
                    break;
                }
                case 4: 
                case 5: {
                    String string = ((KnownLengthStringValue)applicationData).getValue();
                    long l = Long.parseLong(string, 16);
                    simpleTypesWriter.write(l);
                    break;
                }
                case 1: 
                case 6: 
                case 7: 
                case 8: {
                    String string = ((KnownLengthStringValue)applicationData).getValue();
                    long l = Long.parseLong(string, 10);
                    simpleTypesWriter.write(l);
                    break;
                }
            }
            applicationData2 = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
        }
        catch (IOException iOException) {
            EventLog.instance().log("Could not read the meta data from this ecldataentry, or write the data to send to the server.");
        }
        catch (ClassCastException classCastException) {
            EventLog.instance().log("OvSetupBytesReader - unexpected application data type was received! ");
        }
        return applicationData2;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = false;
        switch (n) {
            case 2: {
                LockableBoolean lockableBoolean = new LockableBoolean(this.m_enable);
                bl2 = ((LockableBooleanPropertyAccessor)propertyAccessor).setLockableBooleanProperty(lockableBoolean);
                break;
            }
            case 3: {
                MaskedIntegerValue maskedIntegerValue = new MaskedIntegerValue(this.m_polarity, 3L, 3L);
                bl2 = ((MaskedIntegerPropertyAccessor)propertyAccessor).setMaskedIntegerValue(maskedIntegerValue);
                break;
            }
            case 1: {
                String string = "" + this.m_hwId;
                bl2 = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 4: {
                String string = this.convertLongToHexString(this.m_value, 2);
                bl2 = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 5: {
                String string = this.convertLongToHexString(this.m_mask, 2);
                bl2 = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 6: {
                String string = "" + this.m_byteOffset;
                bl2 = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 7: {
                String string = "" + this.m_bitOffset;
                bl2 = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 8: {
                String string = "" + this.m_groupId;
                bl2 = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 9: {
                bl2 = ((TextPropertyAccessor)propertyAccessor).setTextProperty(this.m_ownerName);
            }
        }
        if (n == 4 || n == 5 || n == 6 || n == 7 || n == 8 || n == 8) {
            ((GreyPropertyAccessor)propertyAccessor).setGreyProperty(false);
        }
        propertyAccessor.repaint();
        return bl2;
    }
}

