/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.tstfunc_usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.LockableBooleanPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.MaskedIntegerPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.datatype.LockableBoolean;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import java.io.IOException;

public class EncapAnalyTriggerFieldValueInBitsReader
extends GenericDataReader {
    private static final int CHECKBOX_ID_OFFSET = 0;
    private static final int COMBO_ID_OFFSET = 1;
    private static final int BINARY_ENTRY_ID_OFFSET = 2;
    private static final int NUM_COMPONENTS = 3;
    long[] m_groupBitMask;
    long[] m_groupBitOffset;
    int[] m_numBitsInGroup;
    int[] m_maxComboIndices;
    long m_fieldValue;
    long m_fieldMask;
    int m_numGroupsInField;
    boolean m_dataReady;
    boolean m_repaintRequired;

    public EncapAnalyTriggerFieldValueInBitsReader(int n, int[] nArray) {
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            double d = Math.pow(2.0, nArray[n2]);
            nArray2[n2] = n3 = new Double(d).intValue();
            ++n2;
        }
        this.Initialise(n, nArray, nArray2);
    }

    public EncapAnalyTriggerFieldValueInBitsReader(int n, int[] nArray, int[] nArray2) {
        this.Initialise(n, nArray, nArray2);
    }

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        try {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            primitiveTypesReader.readLong();
            primitiveTypesReader.readBoolean();
            primitiveTypesReader.readBoolean();
            this.m_fieldValue = primitiveTypesReader.readLong();
            this.m_fieldMask = primitiveTypesReader.readLong();
            this.m_repaintRequired = true;
            this.m_dataReady = true;
        }
        catch (IOException iOException) {
            this.m_dataReady = false;
        }
        return true;
    }

    private String convertLongToBinString(long l, int n) {
        String string = Long.toBinaryString(l).toUpperCase();
        while (string.length() < n) {
            string = "0" + string;
        }
        return string;
    }

    public int getChangeCompositeID(ApplicationData applicationData) throws IOException {
        ApplicationGenericMetaData applicationGenericMetaData = (ApplicationGenericMetaData)applicationData.description();
        SimpleTypesReader simpleTypesReader = new SimpleTypesReader();
        simpleTypesReader.initialiseByteArrayToRead(applicationGenericMetaData.getByteArray());
        int n = simpleTypesReader.readInt();
        return n;
    }

    public void Initialise(int n, int[] nArray, int[] nArray2) {
        this.m_numGroupsInField = n;
        this.m_groupBitOffset = new long[this.m_numGroupsInField];
        this.m_groupBitMask = new long[this.m_numGroupsInField];
        this.m_numBitsInGroup = new int[this.m_numGroupsInField];
        this.m_maxComboIndices = new int[this.m_numGroupsInField];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            this.m_numBitsInGroup[n3] = nArray[n3];
            this.m_maxComboIndices[n3] = nArray2[n3];
            this.m_groupBitOffset[n3] = n2;
            this.m_groupBitMask[n3] = (1 << nArray[n3]) - 1;
            this.m_groupBitMask[n3] = this.m_groupBitMask[n3] << (int)this.m_groupBitOffset[n3];
            n2 += nArray[n3];
            ++n3;
        }
    }

    public ApplicationData modifyDataToChange(ApplicationData applicationData) {
        ApplicationData applicationData2 = applicationData;
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            int n = this.getChangeCompositeID(applicationData);
            int n2 = n % 3;
            int n3 = n / 3;
            switch (n2) {
                case 0: {
                    int n4 = ((MaskedIntegerValue)applicationData).getValue();
                    this.m_fieldMask = n4 == 1 ? (this.m_fieldMask |= this.m_groupBitMask[n3]) : (this.m_fieldMask &= this.m_groupBitMask[n3] ^ 0xFFFFFFFFFFFFFFFFL);
                    simpleTypesWriter.write(4);
                    simpleTypesWriter.write(this.m_fieldMask);
                    break;
                }
                case 1: 
                case 2: {
                    int n5 = 0;
                    n5 = n2 == 1 ? ((MaskedIntegerValue)applicationData).getValue() : Integer.parseInt(((KnownLengthStringValue)applicationData).getValue(), 2);
                    this.m_fieldValue &= this.m_groupBitMask[n3] ^ 0xFFFFFFFFFFFFFFFFL;
                    this.m_fieldValue |= (long)(n5 << (int)this.m_groupBitOffset[n3]);
                    simpleTypesWriter.write(3);
                    simpleTypesWriter.write(this.m_fieldValue);
                    break;
                }
            }
            applicationData2 = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
        }
        catch (IOException iOException) {
            EventLog.instance().log("EncapAnalyTriggerFieldValueInBitsReader - Could not read the meta data from this ecldataentry, or write the data to send to the server.");
        }
        catch (ClassCastException classCastException) {
            EventLog.instance().log("EncapAnalyTriggerFieldValueInBitsReader - unexpected application data type was received! ");
        }
        return applicationData2;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = false;
        int n2 = n % 3;
        int n3 = n / 3;
        switch (n2) {
            case 0: {
                boolean bl3 = (this.m_fieldMask & this.m_groupBitMask[n3]) == this.m_groupBitMask[n3];
                LockableBoolean lockableBoolean = new LockableBoolean(bl3);
                bl2 = ((LockableBooleanPropertyAccessor)propertyAccessor).setLockableBooleanProperty(lockableBoolean);
                break;
            }
            case 1: {
                int n4 = new Long((this.m_fieldValue & this.m_groupBitMask[n3]) >> (int)this.m_groupBitOffset[n3]).intValue();
                if (n4 >= this.m_maxComboIndices[n3]) {
                    n4 = this.m_maxComboIndices[n3] - 1;
                }
                int n5 = (1 << this.m_maxComboIndices[n3]) - 1;
                MaskedIntegerValue maskedIntegerValue = new MaskedIntegerValue(n4, (long)n5, (long)n5);
                bl2 = ((MaskedIntegerPropertyAccessor)propertyAccessor).setMaskedIntegerValue(maskedIntegerValue);
                break;
            }
            case 2: {
                int n6 = new Long((this.m_fieldValue & this.m_groupBitMask[n3]) >> (int)this.m_groupBitOffset[n3]).intValue();
                String string = this.convertLongToBinString(n6, this.m_numBitsInGroup[n3]);
                bl2 = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
            }
        }
        if (this.m_repaintRequired || bl) {
            propertyAccessor.repaint();
        }
        return bl2;
    }
}

