/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.tstfunc_usercode;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.LockableBooleanPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.MaskedIntegerPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.datatype.LockableBoolean;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import java.io.IOException;

public class EncapAnalyTriggerFieldValueReader
extends GenericDataReader {
    private static final int CHECKBOX_ID = 1;
    private static final int POLARITY_COMBO_ID = 2;
    private static final int FIELDVALUE_ID = 3;
    private static final int FIELDMASK_ID = 4;
    boolean m_checkboxState;
    boolean m_oldCheckboxState;
    int m_polarity;
    int m_oldPolarity;
    long m_fieldValue;
    long m_oldFieldValue;
    long m_fieldMask;
    long m_oldFieldMask;
    int m_numBitsInFieldVal;
    boolean m_dataReady;
    boolean m_repaintRequired;

    public EncapAnalyTriggerFieldValueReader(int n) {
        this.m_numBitsInFieldVal = n;
        this.m_oldCheckboxState = false;
        this.m_oldPolarity = 1;
        this.m_oldFieldValue = 0L;
        this.m_oldFieldMask = 0L;
    }

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        try {
            this.m_oldCheckboxState = this.m_checkboxState;
            this.m_oldPolarity = this.m_polarity;
            this.m_oldFieldValue = this.m_fieldValue;
            this.m_oldFieldMask = this.m_fieldMask;
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            long l = primitiveTypesReader.readLong();
            if (l != (long)this.m_numBitsInFieldVal) {
                EventLog.instance().log("EncapAnalyTriggerFieldValueReader - invalid number of bits received from server.");
            }
            this.m_checkboxState = primitiveTypesReader.readBoolean();
            boolean bl = primitiveTypesReader.readBoolean();
            this.m_fieldValue = primitiveTypesReader.readLong();
            this.m_fieldMask = primitiveTypesReader.readLong();
            this.m_polarity = bl ? 1 : 0;
            this.m_repaintRequired = this.m_oldCheckboxState != this.m_checkboxState || this.m_oldPolarity != this.m_polarity || this.m_oldFieldValue != this.m_fieldValue || this.m_oldFieldMask != this.m_fieldMask;
            this.m_dataReady = true;
        }
        catch (IOException iOException) {
            this.m_dataReady = false;
        }
        return true;
    }

    private String convertLongToHexString(long l, int n) {
        String string = Long.toHexString(l).toUpperCase();
        while (string.length() < n) {
            string = "0" + string;
        }
        return string;
    }

    public int getChangeCompositeID(ApplicationData applicationData) throws IOException {
        ApplicationGenericMetaData applicationGenericMetaData = (ApplicationGenericMetaData)applicationData.description();
        SimpleTypesReader simpleTypesReader = new SimpleTypesReader();
        simpleTypesReader.initialiseByteArrayToRead(applicationGenericMetaData.getByteArray());
        int n = simpleTypesReader.readInt();
        return n;
    }

    public ApplicationData modifyDataToChange(ApplicationData applicationData) {
        ApplicationData applicationData2 = applicationData;
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            int n = this.getChangeCompositeID(applicationData);
            simpleTypesWriter.write(n);
            switch (n) {
                case 1: {
                    int n2 = ((MaskedIntegerValue)applicationData).getValue();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    simpleTypesWriter.write(bl);
                    break;
                }
                case 2: {
                    int n3 = ((MaskedIntegerValue)applicationData).getValue();
                    boolean bl = false;
                    if (n3 != 0) {
                        bl = true;
                    }
                    simpleTypesWriter.write(bl);
                    break;
                }
                case 3: 
                case 4: {
                    String string = ((KnownLengthStringValue)applicationData).getValue();
                    while (string.length() < 16) {
                        string = "0" + string;
                    }
                    String string2 = string.substring(8, 16);
                    String string3 = string.substring(0, 8);
                    long l = Long.parseLong(string2, 16);
                    long l2 = Long.parseLong(string3, 16);
                    long l3 = (l2 << 32) + l;
                    simpleTypesWriter.write(l3);
                    break;
                }
            }
            applicationData2 = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
        }
        catch (IOException iOException) {
            EventLog.instance().log("Could not read the meta data from this ecldataentry, or write the data to send to the server.");
        }
        catch (ClassCastException classCastException) {
            EventLog.instance().log("OvSetupBytesReader - unexpected application data type was received! ");
        }
        return applicationData2;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = false;
        switch (n) {
            case 1: {
                LockableBoolean lockableBoolean = new LockableBoolean(this.m_checkboxState);
                bl2 = ((LockableBooleanPropertyAccessor)propertyAccessor).setLockableBooleanProperty(lockableBoolean);
                break;
            }
            case 2: {
                MaskedIntegerValue maskedIntegerValue = new MaskedIntegerValue(this.m_polarity, 3L, 3L);
                bl2 = ((MaskedIntegerPropertyAccessor)propertyAccessor).setMaskedIntegerValue(maskedIntegerValue);
                break;
            }
            case 3: {
                String string = this.convertLongToHexString(this.m_fieldValue, this.m_numBitsInFieldVal / 4);
                bl2 = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
                break;
            }
            case 4: {
                String string = this.convertLongToHexString(this.m_fieldMask, this.m_numBitsInFieldVal / 4);
                bl2 = ((TextPropertyAccessor)propertyAccessor).setTextProperty(string);
            }
        }
        if (this.m_repaintRequired || bl) {
            propertyAccessor.repaint();
        }
        return bl2;
    }
}

