/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.txrx;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.TextPropertyAccessor;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import com.agilent.tntd.lynx.txrx.IntegerDataEntryData;
import java.io.IOException;

public class IntegerDataEntryReader
extends GenericDataReader {
    private int numElements;
    private boolean[] repaintRequired;
    private IntegerDataEntryData[] entry;
    private boolean dataReady;
    private IntegerDataEntryData currentEntry;

    public IntegerDataEntryReader(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.numElements = n;
        this.entry = new IntegerDataEntryData[this.numElements];
        int n2 = 0;
        while (n2 < this.entry.length) {
            this.entry[n2] = new IntegerDataEntryData();
            ++n2;
        }
        this.repaintRequired = new boolean[this.numElements];
        this.currentEntry = new IntegerDataEntryData();
    }

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        try {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            short s = primitiveTypesReader.readShort();
            if (s == this.numElements) {
                int n = 0;
                while (n < this.numElements) {
                    this.entry[n].deserialize(primitiveTypesReader);
                    this.repaintRequired[n] = true;
                    ++n;
                }
            } else {
                int n = 0;
                while (n < this.numElements) {
                    this.repaintRequired[n] = false;
                    ++n;
                }
                this.currentEntry.deserialize(primitiveTypesReader);
                n = this.currentEntry.getByteID();
                this.entry[n].copy(this.currentEntry);
                this.repaintRequired[n] = true;
            }
            this.dataReady = true;
        }
        catch (IOException iOException) {
            this.dataReady = false;
        }
        return true;
    }

    public boolean isDataReady() {
        return this.dataReady;
    }

    public ApplicationData modifyDataToChange(ApplicationData applicationData) {
        if (applicationData.description() instanceof ApplicationGenericMetaData) {
            ApplicationGenericData applicationGenericData;
            ApplicationGenericMetaData applicationGenericMetaData = (ApplicationGenericMetaData)applicationData.description();
            SimpleTypesReader simpleTypesReader = new SimpleTypesReader();
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesReader.initialiseByteArrayToRead(applicationGenericMetaData.getByteArray());
            simpleTypesWriter.initialiseByteArrayToWrite();
            try {
                int n = simpleTypesReader.readInt();
                short s = this.entry[n].getByteID();
                simpleTypesWriter.write(s);
                simpleTypesWriter.write(((KnownLengthStringValue)applicationData).getValue());
                applicationGenericData = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
            }
            catch (IOException iOException) {
                EventLog.instance().log("Could not read the meta data from this eclDataEntry - float, or write the data to send to the server.");
                applicationGenericData = new ApplicationGenericData(null);
            }
            catch (ClassCastException classCastException) {
                EventLog.instance().log("VCatSettingsFloatDataEntryData - unexpected application data type was received! ");
                applicationGenericData = new ApplicationGenericData(null);
            }
            return applicationGenericData;
        }
        return applicationData;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = this.dataReady;
        int n2 = n;
        if (this.dataReady && (bl || this.repaintRequired[n2])) {
            if (propertyAccessor instanceof TextPropertyAccessor) {
                bl2 &= ((TextPropertyAccessor)propertyAccessor).setTextProperty(this.entry[n2].getValue());
            }
            if (propertyAccessor instanceof GreyPropertyAccessor) {
                bl2 &= ((GreyPropertyAccessor)propertyAccessor).setGreyProperty(this.entry[n2].getGreyed());
            }
            propertyAccessor.repaint();
        }
        return bl2;
    }
}

