/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.txrx;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.GenericDataReader;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.GreyPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.LockableBooleanPropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.compositedata.PropertyAccessor;
import com.agilent.tntd.eclipse.bottomlayer.datatype.LockableBoolean;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesReader;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import com.agilent.tntd.lynx.txrx.VCatSettingsEnabledContainerData;
import java.io.IOException;

public class VCatSettingsCheckboxReader
extends GenericDataReader {
    private int numElements;
    private boolean[] repaintRequired;
    private VCatSettingsEnabledContainerData[] enabledContainers;
    private boolean dataReady;
    private VCatSettingsEnabledContainerData currentContainer;

    public VCatSettingsCheckboxReader(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.numElements = n;
        this.enabledContainers = new VCatSettingsEnabledContainerData[this.numElements];
        int n2 = 0;
        while (n2 < this.enabledContainers.length) {
            this.enabledContainers[n2] = new VCatSettingsEnabledContainerData();
            ++n2;
        }
        this.repaintRequired = new boolean[this.numElements];
        this.currentContainer = new VCatSettingsEnabledContainerData();
    }

    public boolean changeInnerData(ApplicationGenericData applicationGenericData) {
        try {
            PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
            short s = primitiveTypesReader.readShort();
            if (s == this.numElements) {
                int n = 0;
                while (n < this.numElements) {
                    this.enabledContainers[n].deserialize(primitiveTypesReader);
                    this.repaintRequired[n] = true;
                    ++n;
                }
            } else {
                int n = 0;
                while (n < this.numElements) {
                    this.repaintRequired[n] = false;
                    ++n;
                }
                this.currentContainer.deserialize(primitiveTypesReader);
                n = this.currentContainer.getByteID();
                this.enabledContainers[n].copy(this.currentContainer);
                this.repaintRequired[n] = true;
            }
            this.dataReady = true;
        }
        catch (IOException iOException) {
            this.dataReady = false;
        }
        return true;
    }

    public VCatSettingsEnabledContainerData[] getEnableContainers() {
        return this.enabledContainers;
    }

    public boolean isDataReady() {
        return this.dataReady;
    }

    public ApplicationData modifyDataToChange(ApplicationData applicationData) {
        if (applicationData.description() instanceof ApplicationGenericMetaData) {
            ApplicationGenericData applicationGenericData;
            ApplicationGenericMetaData applicationGenericMetaData = (ApplicationGenericMetaData)applicationData.description();
            SimpleTypesReader simpleTypesReader = new SimpleTypesReader();
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesReader.initialiseByteArrayToRead(applicationGenericMetaData.getByteArray());
            simpleTypesWriter.initialiseByteArrayToWrite();
            try {
                int n = simpleTypesReader.readInt();
                short s = this.enabledContainers[n].getByteID();
                int n2 = ((MaskedIntegerValue)applicationData).getValue();
                boolean bl = n2 == 1;
                boolean bl2 = ((MaskedIntegerValue)applicationData).getStateMask().areAllBitsClear();
                simpleTypesWriter.write(s);
                simpleTypesWriter.write(bl);
                simpleTypesWriter.write(bl2);
                applicationGenericData = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
            }
            catch (IOException iOException) {
                EventLog.instance().log("Could not read the meta data from this eclCheckbox, or write the data to send to the server.");
                applicationGenericData = new ApplicationGenericData(null);
            }
            catch (ClassCastException classCastException) {
                EventLog.instance().log("VCatSettingsCheckboxReader - unexpected application data type was received! ");
                applicationGenericData = new ApplicationGenericData(null);
            }
            return applicationGenericData;
        }
        return applicationData;
    }

    public boolean update(int n, PropertyAccessor propertyAccessor, boolean bl) {
        boolean bl2 = this.dataReady;
        int n2 = n % this.numElements;
        if (this.dataReady && (bl || this.repaintRequired[n2])) {
            bl2 &= this.updateCheckbox(bl2, propertyAccessor, n2);
            propertyAccessor.repaint();
        }
        return bl2;
    }

    public boolean updateCheckbox(boolean bl, PropertyAccessor propertyAccessor, int n) {
        if (bl && propertyAccessor instanceof LockableBooleanPropertyAccessor) {
            bl &= ((LockableBooleanPropertyAccessor)propertyAccessor).setLockableBooleanProperty(new LockableBoolean(this.enabledContainers[n].getActive(), this.enabledContainers[n].getLocked()));
        }
        if (propertyAccessor instanceof GreyPropertyAccessor) {
            bl &= ((GreyPropertyAccessor)propertyAccessor).setGreyProperty(this.enabledContainers[n].getLocked());
        }
        return bl;
    }
}

