/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.txrx.mixedbackground;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;

public class DBconnection
implements CcConnectedComponent,
MaskedIntegerDataReceiver {
    private ApplicationObject theAppObject = null;
    private String dbVariable = "";
    private int dbValue = -1;
    private int priority = 0;
    private MaskedIntegerDataReceiver dataHandler = null;
    private int currentValue = -1;
    public boolean hasTrappedTransientError = false;
    public boolean hasTrappedPermanentError = false;
    private DBconnection SignalMode = null;

    public DBconnection(MaskedIntegerDataReceiver maskedIntegerDataReceiver, String string, int n) {
        this.dataHandler = maskedIntegerDataReceiver;
        this.dbVariable = string;
        this.priority = n;
        this.initialize();
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            System.out.println("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because " + applicationObject.toString() + " failed to initialise.");
            this.permanentError();
        } else {
            this.theAppObject = applicationObject;
        }
    }

    public void finishInitialise() {
    }

    public ApplicationObject getAppObject() {
        return this.theAppObject;
    }

    public int getDBValue() {
        return this.dbValue;
    }

    public String getName() {
        return this.dbVariable;
    }

    public int getValue() {
        return this.currentValue;
    }

    public void initialize() {
        this.trapTransientError(true);
        ApplicationManager.instance().request("ISS", this.priority, this.dbVariable, (ApplicationObjectObserver)this);
    }

    public void permanentError() {
        this.hasTrappedTransientError = false;
        this.hasTrappedPermanentError = true;
        System.out.println("ERROR: " + this.toString() + ": A permanent error occurred in application object " + this.theAppObject.toString());
        this.unregister();
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        this.trapTransientError(false);
        this.dbValue = maskedIntegerValue.getValue();
        this.dataHandler.receiveMaskedIntegerData(maskedIntegerValue, applicationDataSender);
    }

    public void revertToLastReceivedValue() {
        this.setValue(this.dbValue);
    }

    public void setValue(int n) {
        this.currentValue = n;
    }

    public boolean setValueInDatabase() {
        return this.setValueInDatabase(this.currentValue);
    }

    public boolean setValueInDatabase(int n) {
        MaskedIntegerValue maskedIntegerValue = new MaskedIntegerValue(n);
        boolean bl = true;
        if (!this.theAppObject.change((ApplicationData)maskedIntegerValue)) {
            System.out.println("ERROR: " + this.toString() + ": setValueInDatabase: ISS refused to change the value.");
            System.out.println("ERROR: " + this.toString() + ": setValueInDatabase: Current value = " + this.getValue() + " Failed new value = " + n);
            bl = false;
        }
        return bl;
    }

    public String toString() {
        String string = this.getName();
        String string2 = string == null || string.length() == 0 ? "DBconnection" : string;
        return String.valueOf(string2) + "[" + this.dbVariable + "]";
    }

    public void trapTransientError(boolean bl) {
        this.hasTrappedTransientError = bl;
    }

    public void unregister() {
        if (this.theAppObject != null) {
            this.theAppObject.unregister((ApplicationObjectObserver)this);
            this.theAppObject = null;
        }
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            System.out.println("ERROR: " + this.toString() + "update: The interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString() + " is not implemented");
            this.permanentError();
        }
    }
}

