/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.txrx.mixedbackground;

import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.BasicLabel;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.EclToggleButton;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.DialogEventReceiver;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.EclDialog;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindow;
import com.agilent.tntd.eclipse.viewlayer.containers.window.ModalWindowHandler;
import com.agilent.tntd.lynx.txrx.mixedbackground.DBconnection;
import com.agilent.tntd.lynx.txrx.mixedbackground.MapWizDisplayTiler;
import com.agilent.tntd.lynx.txrx.mixedbackground.MapWizTile;
import com.agilent.tntd.lynx.txrx.mixedbackground.TelecomsHelper;
import com.agilent.tntd.lynx.txrx.mixedbackground.rmi.MapwizServerProxy;
import com.agilent.tntd.lynx.txrx.mixedbackground.rmi.MapwizStructureObserver;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class MapWizDirector
implements MaskedIntegerDataReceiver,
DialogEventReceiver,
MapwizStructureObserver,
ItemListener,
KeyListener {
    private ModalWindowHandler fieldMapWizWindowCloser = new ModalWindowHandler();
    protected transient PropertyChangeSupport propertyChange;
    protected String mapWizClientName;
    public MapwizServerProxy clientServerInterface = null;
    protected MapWizDisplayTiler theTiler = null;
    protected MapWizTile currentItem = null;
    public int hasTileSelected = -1;
    private int signalSize = 0;
    private int foregroundStart;
    protected DBconnection signalMode = null;
    protected DBconnection signalRate = null;
    public DBconnection vcatMode;
    public DBconnection lcasMode;
    public static MapWizDirector instance;
    protected int maxSQI;
    protected DBconnection mixedAvailable;
    private BasicLabel fieldMixedStartLabel = new BasicLabel();
    private BasicLabel fieldVcatStartLabel = new BasicLabel();
    private BasicLabel fieldVcatGroupLabel = new BasicLabel();
    protected int vcatMemberSize;
    private int vcatGroupSize;
    public DBconnection checkSQI = null;
    private boolean menuActive = false;
    protected boolean bLoDisplay = false;
    protected DBconnection vcatOrder = null;
    public static final int DATABASE_TX = 0;
    public static final int DATABASE_RX = 1;
    public static final int MAX_SQI_LO = 63;
    public static final int MAX_SQI_HO = 255;
    protected short multiAuSize;
    protected short[] multiAu;
    protected boolean isMultiAu4;
    public DBconnection tuMapping = null;

    public MapWizDirector() {
        this.mixedAvailable = new DBconnection(this, "INST_FEATOPT_CONCAT_ENH", 0);
        instance = this;
    }

    public void activateConnection() {
        if (this.clientServerInterface == null) {
            this.clientServerInterface = new MapwizServerProxy(this.mapWizClientName, this);
        }
        this.clientServerInterface.register();
    }

    public void activateMenu() {
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChange().addPropertyChangeListener(propertyChangeListener);
    }

    public void clearVCAT() {
        this.clientServerInterface.setVcat((short)-1, 0);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChange().firePropertyChange(string, object, object2);
    }

    public MapWizTile getActiveComponent() {
        return this.currentItem;
    }

    public abstract EclToggleButton getExitButton();

    public abstract EclWindow getMapwizWindow();

    public ModalWindowHandler getMapWizWindowCloser() {
        return this.fieldMapWizWindowCloser;
    }

    public int getMaxSQIAdd() {
        int n = this.bLoDisplay ? 63 : 255;
        return n;
    }

    public int getMaxSQIChange() {
        int n = this.bLoDisplay ? 63 : 255;
        if (this.checkSQI != null && this.checkSQI.getDBValue() == 1 && this.maxSQI <= n) {
            n = this.maxSQI;
        }
        return n;
    }

    public BasicLabel getMixedStartLabel() {
        return this.fieldMixedStartLabel;
    }

    public short getMultiAuSize() {
        return this.multiAuSize;
    }

    protected PropertyChangeSupport getPropertyChange() {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        return this.propertyChange;
    }

    public BasicLabel getVcatGroupLabel() {
        return this.fieldVcatGroupLabel;
    }

    public BasicLabel getVcatStartLabel() {
        return this.fieldVcatStartLabel;
    }

    public void handleError(short s) {
        EclDialog eclDialog = new EclDialog();
        eclDialog.setSize(328, 186);
        switch (s) {
            case -1: {
                eclDialog.displayMessageWindow(false, true, false, "Increasing the size of this channel would affect a VCAT group member. To make the change please remove the VCAT group member first.", "Mapping Change failed", (DialogEventReceiver)this, null);
                break;
            }
            case -2: {
                if (this.checkSQI.getDBValue() == 1) {
                    eclDialog.displayMessageWindow(false, true, false, "Unable to recover a valid VCAT group. The signal may have errors in it, or there may not be a valid set of SQI numbers present", "Group Recovery Failure", (DialogEventReceiver)this, null);
                    break;
                }
                eclDialog.displayMessageWindow(false, true, false, "Unable to find a VCAT group. Resetting Configuration to default!", "Group Recovery Failure", (DialogEventReceiver)this, null);
                break;
            }
            case -3: {
                eclDialog.displayMessageWindow(false, true, false, "Too many High Order VCAT Enable channels.", "High Order VCAT Enable Failure", (DialogEventReceiver)this, null);
                break;
            }
            case -4: {
                if (this.tuMapping.getDBValue() == 1) {
                    eclDialog.displayMessageWindow(false, true, false, "Unable to add TU-3 channel. Selected TU-3 channels must be contained within 16 AU-4s.", "Channel Add Failure", (DialogEventReceiver)this, null);
                    break;
                }
                eclDialog.displayMessageWindow(false, true, false, "Unable to add channel. Maximum channel number exceeded.", "Channel Add Failure", (DialogEventReceiver)this, null);
                break;
            }
            case -5: {
                eclDialog.displayMessageWindow(false, true, false, "Unable to set foreground channel. Set foreground channel using Low Order mapping configuration", "Set Foreground Failure", (DialogEventReceiver)this, null);
                break;
            }
            default: {
                System.out.println("Unknown Error Code Received!");
            }
        }
    }

    public boolean isMenuActive() {
        return this.menuActive;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            if (!this.menuActive) {
                this.getMixedStartLabel().setText("...");
                this.getVcatStartLabel().setText("...");
            }
        } else if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getItem() != null) {
                this.currentItem = (MapWizTile)((Object)itemEvent.getItem());
                this.getMixedStartLabel().setText(TelecomsHelper.getStartLabel(this.currentItem.getStart(), this.currentItem.getText(), this.vcatMemberSize, this.bLoDisplay));
                this.getVcatStartLabel().setText(TelecomsHelper.getStartLabel(this.currentItem.getStart(), this.currentItem.getText(), this.vcatMemberSize, this.bLoDisplay, this.multiAuSize, this.isMultiAu4, this.multiAu));
                this.getVcatGroupLabel().setText(TelecomsHelper.getGroupLabel(this.vcatMemberSize, this.vcatGroupSize, this.bLoDisplay));
            } else if (!this.menuActive) {
                this.getMixedStartLabel().setText("...");
                this.getVcatStartLabel().setText("...");
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.activateMenu();
        } else if (keyEvent.getKeyCode() == 107) {
            this.activateMenu();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mapwizResetAU3() {
        this.clientServerInterface.setChannel((short)-1, (short)1);
    }

    public void mapwizResetAU4() {
        this.clientServerInterface.setChannel((short)-1, (short)3);
    }

    public void notifyEvent(int n, EclDialog eclDialog) {
        eclDialog.removeFromWorkspace();
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
    }

    public void recoverSQIs() {
        this.clientServerInterface.requestSQIRecovery();
        this.theTiler.requestFocus();
    }

    public void refreshSegment(short s, short s2, short s3, short s4, short s5, short n, short n2, short[] sArray, short[] sArray2, short[] sArray3) {
        TelecomsHelper.setMode(this.signalMode.getDBValue());
        TelecomsHelper.setRate(this.signalRate.getDBValue());
        this.signalSize = s;
        this.vcatMemberSize = s3;
        this.vcatGroupSize = s4;
        this.maxSQI = s5;
        if (this.theTiler != null) {
            int n3;
            int n4;
            this.theTiler.supressUpdates(true);
            if (n2 == 0 || s != this.signalSize) {
                this.theTiler.removeAll();
            } else {
                n4 = n;
                n3 = 0;
                while (n3 < n2) {
                    n4 += sArray[n3];
                    ++n3;
                }
                this.theTiler.remove(n, --n4);
            }
            n4 = n;
            n3 = 0;
            while (n3 < n2) {
                if (n3 < sArray.length) {
                    MapWizTile mapWizTile = new MapWizTile(TelecomsHelper.getSizeStr(sArray[n3], n4 == s2, sArray2[n3], sArray3[n3], this.bLoDisplay), n4, sArray[n3], n4 == s2, sArray2[n3], sArray3[n3]);
                    mapWizTile.setFont(new Font("dialog", 0, 10));
                    this.setBkColor(mapWizTile, n4 == s2, sArray2[n3]);
                    ((Component)((Object)mapWizTile)).addKeyListener(this);
                    if (n4 > s) {
                        System.out.println("Tried to overrun the tile display!");
                    }
                    this.theTiler.add(mapWizTile, new Integer(sArray[n3]), n4);
                    n4 += sArray[n3];
                }
                ++n3;
            }
            this.theTiler.supressUpdates(false);
            this.theTiler.setSelectedTile(this.hasTileSelected);
            if (this.theTiler.hasTiles()) {
                this.theTiler.requestFocus();
            } else {
                this.getExitButton().requestFocus();
            }
        } else {
            System.out.println("Error!! = no tiler");
        }
        this.foregroundStart = s2;
    }

    public void refreshSegment(short s, short s2, short s3, short s4, short s5, short n, short n2, short[] sArray, short[] sArray2, short[] sArray3, short s6, short s7, short[] sArray4) {
        TelecomsHelper.setMode(this.signalMode.getDBValue());
        TelecomsHelper.setRate(this.signalRate.getDBValue());
        this.signalSize = s;
        this.vcatMemberSize = s3;
        this.vcatGroupSize = s4;
        this.maxSQI = s5;
        this.multiAuSize = s6;
        this.multiAu = sArray4;
        boolean bl = this.isMultiAu4 = s7 != 0;
        if (this.theTiler != null) {
            int n3;
            int n4;
            this.theTiler.supressUpdates(true);
            if (n2 == 0 || s != this.signalSize) {
                this.theTiler.removeAll();
            } else {
                n4 = n;
                n3 = 0;
                while (n3 < n2) {
                    n4 += sArray[n3];
                    ++n3;
                }
                this.theTiler.remove(n, --n4);
            }
            n4 = n;
            n3 = 0;
            while (n3 < n2) {
                if (n3 < sArray.length) {
                    MapWizTile mapWizTile = new MapWizTile(TelecomsHelper.getSizeStr(sArray[n3], n4 == s2, sArray2[n3], sArray3[n3], this.bLoDisplay), n4, sArray[n3], n4 == s2, sArray2[n3], sArray3[n3]);
                    mapWizTile.setFont(new Font("dialog", 0, 10));
                    this.setBkColor(mapWizTile, n4 == s2, sArray2[n3]);
                    ((Component)((Object)mapWizTile)).addKeyListener(this);
                    if (n4 > s) {
                        System.out.println("Tried to overrun the tile display!");
                    }
                    this.theTiler.add(mapWizTile, new Integer(sArray[n3]), n4);
                    n4 += sArray[n3];
                }
                ++n3;
            }
            this.theTiler.supressUpdates(false);
            this.theTiler.setSelectedTile(this.hasTileSelected);
            if (this.theTiler.hasTiles()) {
                this.theTiler.requestFocus();
            } else {
                this.getExitButton().requestFocus();
            }
        } else {
            System.out.println("Error!! = no tiler");
        }
        this.foregroundStart = s2;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChange().removePropertyChangeListener(propertyChangeListener);
    }

    public void sendSQIUpdate(int n) {
        this.clientServerInterface.setSQI((short)this.hasTileSelected, (short)n);
        this.theTiler.requestFocus();
    }

    public void setBkColor(MapWizTile mapWizTile, boolean bl, short s) {
        if (bl) {
            ((Component)((Object)mapWizTile)).setBackground(MapWizTile.fgColour);
        } else if (s != 0 && s != 4) {
            ((Component)((Object)mapWizTile)).setBackground(MapWizTile.memberColour);
        } else if (s == 4) {
            ((Component)((Object)mapWizTile)).setBackground(MapWizTile.blankColour);
        } else {
            ((Component)((Object)mapWizTile)).setBackground(MapWizTile.otherColour);
        }
    }

    public void setDatabaseVariables(int n) {
        switch (n) {
            case 1: {
                this.signalMode = new DBconnection(this, "RX_SIGNAL_STD", 0);
                this.signalRate = new DBconnection(this, "RX_SIGNAL_RATE", 0);
                this.vcatMode = new DBconnection(this, "RX_MAPPING_STRUCTURE", 0);
                this.lcasMode = new DBconnection(this, "RX_MAPPING_LCAS", 0);
                this.checkSQI = new DBconnection(this, "APP_MAPWIZ_RX_INCMPLT_GRP", 0);
                this.vcatOrder = new DBconnection(this, "RX_MAPPING_VCAT_ORDER", 0);
                this.tuMapping = new DBconnection(this, "RX_MAPPING_VT_TU", 0);
                break;
            }
            case 0: {
                this.signalMode = new DBconnection(this, "TX_SIGNAL_STD", 0);
                this.signalRate = new DBconnection(this, "TX_SIGNAL_RATE", 0);
                this.vcatMode = new DBconnection(this, "TX_MAPPING_STRUCTURE", 0);
                this.lcasMode = new DBconnection(this, "TX_MAPPING_LCAS", 0);
                this.checkSQI = new DBconnection(this, "APP_MAPWIZ_TX_INCMPLT_GRP", 0);
                this.vcatOrder = new DBconnection(this, "TX_MAPPING_VCAT_ORDER", 0);
                this.tuMapping = new DBconnection(this, "TX_MAPPING_VT_TU", 0);
            }
        }
    }

    public void setForeground(int n) {
        this.hasTileSelected = n;
        this.clientServerInterface.setChannel((short)n, (short)-1);
        this.theTiler.requestFocus();
    }

    public abstract void setMapwizWindow(EclWindow var1);

    public void setMapWizWindowCloser(ModalWindowHandler modalWindowHandler) {
        this.fieldMapWizWindowCloser = modalWindowHandler;
    }

    public void setMenuActive(boolean bl) {
        this.menuActive = bl;
    }

    public void setMixedStartLabel(BasicLabel basicLabel) {
        this.fieldMixedStartLabel = basicLabel;
    }

    public void setSize(int n, int n2) {
        this.hasTileSelected = n;
        this.clientServerInterface.setChannel((short)n, (short)n2);
        this.theTiler.requestFocus();
    }

    public void setSQI(int n) {
        this.hasTileSelected = n;
        if (this.checkSQI.getDBValue() == 0) {
            WindowManager.instance().createWindow("com.agilent.tntd.lynx.txrx.mixedbackground.sqi.SQI_Renumber");
        } else {
            WindowManager.instance().createWindow("com.agilent.tntd.lynx.txrx.mixedbackground.sqi.SQI_Swap");
        }
    }

    public void setTiler(MapWizDisplayTiler mapWizDisplayTiler) {
        this.theTiler = mapWizDisplayTiler;
        mapWizDisplayTiler.addItemListener(this);
    }

    public void setVcatGroupLabel(BasicLabel basicLabel) {
        this.fieldVcatGroupLabel = basicLabel;
    }

    public void setVcatStartLabel(BasicLabel basicLabel) {
        this.fieldVcatStartLabel = basicLabel;
    }

    public void toggleIdleState(int n) {
    }

    public void toggleVcatMultiAuState(int n) {
    }

    public void toggleVcatState(int n) {
    }

    public void unregister() {
        this.signalMode.unregister();
        this.signalRate.unregister();
        this.clientServerInterface.unregister();
    }
}

