/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.txrx.mixedbackground;

public class TelecomsHelper {
    private static int sigMode;
    private static int sigRate;
    public static final int sContiguous = 0;
    public static final int sVcat = 1;
    public static final int sIdle = 2;
    public static final int sDnu = 3;
    public static final int sBlank = 4;
    public static final int sMultiAu = 5;
    public static final int eAu4_64cSize = 192;
    public static final int eAu4_16cSize = 48;
    public static final int eAu4_8cSize = 24;
    public static final int eAu4_4cSize = 12;
    public static final int eAu4_3cSize = 9;
    public static final int eAu4_2cSize = 6;
    public static final int eAu4Size = 3;
    public static final int eAu3Size = 1;
    public static final int eTu3Size = 2;
    public static final int eTu12Size = 4;
    public static final int eTu11Size = 3;
    public static final int eVt2Size = 4;
    public static final int eVt15Size = 3;

    public static boolean[] getActiveItems(int n, int n2, boolean bl, int n3, int n4) {
        boolean[] blArray;
        blArray = new boolean[]{true, n % 3 == 0, n / 3 % 4 != 3 && blArray[1], n / 3 % 4 < 2 && blArray[1], n / 3 % 4 == 0 && blArray[1], n / 3 % 16 < 9 && blArray[1], n / 3 % 16 == 0 && blArray[1], n == 0};
        switch (sigRate) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                blArray[7] = false;
                break;
            }
            case 6: {
                blArray[7] = false;
                blArray[6] = false;
                blArray[5] = false;
                break;
            }
            case 7: {
                blArray[7] = false;
                blArray[6] = false;
                blArray[5] = false;
                blArray[4] = false;
                blArray[3] = false;
                blArray[2] = false;
                break;
            }
            case 9: {
                blArray[7] = false;
                blArray[6] = false;
                blArray[5] = false;
                blArray[4] = false;
                blArray[3] = false;
                blArray[2] = false;
                blArray[1] = false;
            }
        }
        if (n3 != 0 && n3 != 4 || !bl) {
            blArray[7] = false;
            blArray[6] = false;
            blArray[5] = false;
            blArray[4] = false;
            blArray[3] = false;
            blArray[2] = false;
            if (n2 == 1) {
                blArray[1] = false;
            } else {
                blArray[0] = false;
            }
        }
        return blArray;
    }

    public static String getAU3Num(int n) {
        return "" + (n % 3 + 1);
    }

    public static String getAUG16Num(int n) {
        return "" + (n / 48 % 4 + 1);
    }

    public static String getAUG1Num(int n) {
        return "" + (n / 3 % 4 + 1);
    }

    public static String getAUG4Num(int n) {
        return "" + (n / 12 % 4 + 1);
    }

    public static String getAUG64Num(int n) {
        return "1";
    }

    public static String getGroupLabel(int n, int n2) {
        String string = "";
        if (sigMode == 0) {
            string = "VC-";
            string = n == 1 ? String.valueOf(string) + "3" : String.valueOf(string) + "4";
        } else {
            string = "STS-";
            if (n == 1) {
                string = String.valueOf(string) + "1";
            } else if (n == 3) {
                string = String.valueOf(string) + "3c";
            } else {
                return "!";
            }
        }
        if (n2 < 0) {
            return "!";
        }
        string = String.valueOf(string) + "-" + n2 + "v";
        return string;
    }

    public static String getGroupLabel(int n, int n2, boolean bl) {
        if (!bl) {
            return TelecomsHelper.getGroupLabel(n, n2);
        }
        String string = "";
        if (sigMode == 0) {
            string = "VC-";
            string = n == 3 ? String.valueOf(string) + "11" : (n == 4 ? String.valueOf(string) + "12" : String.valueOf(string) + "3");
        } else {
            string = "VT-";
            string = n == 3 ? String.valueOf(string) + "15" : String.valueOf(string) + "2";
        }
        if (n2 < 0) {
            return "!";
        }
        string = String.valueOf(string) + "-" + n2 + "v";
        return string;
    }

    public static String getSizeStr(int n) {
        if (sigMode == 0) {
            if (n == 1) {
                return "AU-3";
            }
            if (n == 3) {
                return "AU-4";
            }
            return "AU-4-" + n / 3 + "c";
        }
        if (n == 1) {
            return "STS-1";
        }
        return "STS-" + n + "c";
    }

    public static String getSizeStr(int n, int n2, int n3) {
        if (n2 == 1) {
            if (n != 1 && n != 2 || n3 < 10) {
                return "SQ " + n3;
            }
            if (n != 1 && n != 2 || n3 > 99) {
                return "" + n3;
            }
            return "SQ" + n3;
        }
        if (n2 == 3) {
            return "DNU";
        }
        if (n2 == 2) {
            return "Idle";
        }
        if (n2 == 4) {
            return "";
        }
        return TelecomsHelper.getSizeStr(n);
    }

    public static String getSizeStr(int n, int n2, int n3, boolean bl) {
        if (n2 == 1) {
            if (n != 1 && n != 2 || n3 < 10) {
                return "SQ " + n3;
            }
            if (n != 1 && n != 2 || n3 > 99) {
                return "" + n3;
            }
            return "SQ" + n3;
        }
        if (n2 == 3) {
            return "DNU";
        }
        if (n2 == 2) {
            return "Idle";
        }
        if (n2 == 4) {
            return "";
        }
        return TelecomsHelper.getSizeStr(n, bl);
    }

    public static String getSizeStr(int n, boolean bl) {
        if (bl) {
            if (sigMode == 0) {
                if (n == 3) {
                    return "TU-11";
                }
                if (n == 4) {
                    return "TU-12";
                }
                return "TU-3";
            }
            if (n == 3) {
                return "VT-15";
            }
            return "VT-2";
        }
        if (sigMode == 0) {
            if (n == 1) {
                return "AU-3";
            }
            if (n == 3) {
                return "AU-4";
            }
            return "AU-4-" + n / 3 + "c";
        }
        if (n == 1) {
            return "STS-1";
        }
        return "STS-" + n + "c";
    }

    public static String getSizeStr(int n, boolean bl, int n2, int n3, boolean bl2) {
        String string = TelecomsHelper.getSizeStr(n, n2, n3, bl2);
        if (string == "" && bl) {
            string = TelecomsHelper.getSizeStr(n, bl2);
        }
        return string;
    }

    public static String getStartLabel(int n, String string, int n2) {
        String string2 = "";
        int n3 = 0;
        if (sigMode == 0) {
            if (string.equals("AU-4-64c")) {
                string2 = "AU-4-64c#";
                n3 = 192;
            } else if (string.equals("AU-4-16c")) {
                string2 = "AU-4-16c#";
                n3 = 48;
            } else if (string.equals("AU-4-8c")) {
                string2 = "AU-4-8c#";
                n3 = 3;
            } else if (string.equals("AU-4-4c")) {
                string2 = "AU-4-4c#";
                n3 = 12;
            } else if (string.equals("AU-4-3c")) {
                string2 = "AU-4-3c#";
                n3 = 3;
            } else if (string.equals("AU-4-2c")) {
                string2 = "AU-4-2c#";
                n3 = 3;
            } else if (string.equals("AU-4")) {
                string2 = "AU-4#";
                n3 = 3;
            } else if (string.equals("AU-3")) {
                string2 = "AU-3c#";
                n3 = 1;
            } else if (n2 == 3) {
                string2 = "AU-4#";
                n3 = 3;
            } else {
                string2 = "AU-3#";
                n3 = 1;
            }
            string2 = String.valueOf(string2) + TelecomsHelper.getStartPosn(n, n3);
        } else {
            string2 = string.startsWith("STS") ? String.valueOf(string) + "#" + TelecomsHelper.getStartPosn(n, string.equals("STS-1") ? 1 : 3) : "STS-" + n2 + '#' + TelecomsHelper.getStartPosn(n, n2);
        }
        return string2;
    }

    public static String getStartLabel(int n, String string, int n2, boolean bl) {
        if (!bl) {
            return TelecomsHelper.getStartLabel(n, string, n2);
        }
        String string2 = "";
        int n3 = 1;
        if (sigMode == 0) {
            if (string.equals("TU-3")) {
                string2 = "TU-3#";
                n3 = 2;
            } else if (string.equals("TU-12")) {
                string2 = "TU-12#";
                n3 = 4;
            } else if (string.equals("TU-11")) {
                string2 = "TU-11#";
                n3 = 3;
            } else {
                string2 = n2 == 4 ? "TU-12#" : (n2 == 3 ? "TU-11#" : "TU-3#");
                n3 = n2;
            }
            string2 = String.valueOf(string2) + TelecomsHelper.getStartPosn(n, n3, bl);
        } else {
            if (!string.equals("VT-2") && !string.equals("VT-15")) {
                string = n2 == 4 ? "VT-2" : "VT-15";
            }
            string2 = String.valueOf(string) + "#" + TelecomsHelper.getStartPosn(n, string.equals("VT-15") ? 3 : 4, bl);
        }
        return string2;
    }

    public static String getStartLabel(int n, String string, int n2, boolean bl, short s, boolean bl2, short[] sArray) {
        if (!bl) {
            return TelecomsHelper.getStartLabel(n, string, n2);
        }
        if (s == 0 || n2 == 2) {
            return TelecomsHelper.getStartLabel(n, string, n2, bl);
        }
        String string2 = "";
        int n3 = 1;
        if (sigMode == 0) {
            if (n2 == 4) {
                string2 = "TU-12#";
                n3 = bl2 ? 63 : 21;
            } else if (n2 == 3) {
                string2 = "TU-11#";
                n3 = bl2 ? 84 : 28;
            } else {
                string2 = "TU-3#";
                n3 = 3;
            }
            int n4 = n3 * n2;
            if (n4 == 0) {
                return string2;
            }
            short s2 = sArray[n / n4];
            int n5 = bl2 ? 3 : 1;
            string2 = String.valueOf(string2) + TelecomsHelper.getStartPosn(s2, n5);
            string2 = n2 == 2 ? String.valueOf(string2) + "," + TelecomsHelper.getAU3Num(n / 2) : String.valueOf(string2) + "," + TelecomsHelper.getStartPosn(n, n2, bl, s, bl2);
        } else {
            if (n2 == 4) {
                string = "VT-2";
                n3 = 21;
            } else {
                string = "VT-15";
                n3 = 28;
            }
            int n6 = n3 * n2;
            if (n6 == 0) {
                return string2;
            }
            short s3 = sArray[n / n6];
            string2 = String.valueOf(string) + "#" + TelecomsHelper.getStartPosn(s3, 1) + "," + TelecomsHelper.getStartPosn(n, n2, bl, s, bl2);
        }
        return string2;
    }

    public static String getStartPosn(int n, int n2) {
        boolean bl = true;
        String string = "";
        if (sigMode == 0) {
            if (sigRate <= 3) {
                string = String.valueOf(string) + "1";
                bl = false;
            }
            if (sigRate <= 5 && n2 <= 48) {
                if (!bl) {
                    string = String.valueOf(string) + ",";
                }
                string = String.valueOf(string) + TelecomsHelper.getAUG16Num(n);
                bl = false;
            }
            if (sigRate <= 6 && n2 <= 12) {
                if (!bl) {
                    string = String.valueOf(string) + ",";
                }
                string = String.valueOf(string) + TelecomsHelper.getAUG4Num(n);
                bl = false;
            }
            if (sigRate <= 7 && n2 <= 3) {
                if (!bl) {
                    string = String.valueOf(string) + ",";
                }
                string = String.valueOf(string) + TelecomsHelper.getAUG1Num(n);
                bl = false;
            }
            if (n2 == 1) {
                if (!bl) {
                    string = String.valueOf(string) + ",";
                }
                string = String.valueOf(string) + TelecomsHelper.getAU3Num(n);
                bl = false;
            }
        } else {
            string = String.valueOf(string) + TelecomsHelper.getSTS3Num(n);
            if (n2 < 3) {
                string = String.valueOf(string) + ',' + TelecomsHelper.getSTS1Num(n);
            }
        }
        return string;
    }

    public static String getStartPosn(int n, int n2, boolean bl) {
        if (!bl) {
            return TelecomsHelper.getStartPosn(n, n2);
        }
        String string = "";
        if (sigMode == 0) {
            if (n2 == 2) {
                return TelecomsHelper.getStartPosn(n / 2, 1);
            }
            int n3 = n / n2 % (n2 == 3 ? 4 : 3) + 1;
            int n4 = n / 12 % 7 + 1;
            int n5 = n / 84 % 3 + 1;
            string = n5 + "," + n4 + "," + n3;
        } else {
            int n6 = n / n2 % (n2 == 3 ? 4 : 3) + 1;
            int n7 = n / 12 + 1;
            string = n7 + "," + n6;
        }
        return string;
    }

    public static String getStartPosn(int n, int n2, boolean bl, short s, boolean bl2) {
        if (!bl) {
            return TelecomsHelper.getStartPosn(n, n2);
        }
        if (s == 0) {
            return TelecomsHelper.getStartPosn(n, n2, bl);
        }
        String string = "";
        if (sigMode == 0) {
            if (n2 == 2) {
                return TelecomsHelper.getStartPosn(n / 2, 1);
            }
            int n3 = n / n2 % (n2 == 3 ? 4 : 3) + 1;
            int n4 = n / 12 % 7 + 1;
            int n5 = n / 84 % 3 + 1;
            string = bl2 ? n5 + "," + n4 + "," + n3 : n4 + "," + n3;
        } else {
            int n6 = n / n2 % (n2 == 3 ? 4 : 3) + 1;
            int n7 = n % 84 / 12 + 1;
            string = n7 + "," + n6;
        }
        return string;
    }

    public static int getSTS1Num(int n) {
        return n % 3 + 1;
    }

    public static int getSTS3Num(int n) {
        return n / 3 + 1;
    }

    public static void setMode(int n) {
        sigMode = n;
    }

    public static void setRate(int n) {
        sigRate = n;
    }
}

