/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.lynx.txrx.mixedbackground.rmi;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.middleware.SimpleTypesWriter;
import com.agilent.tntd.lynx.txrx.mixedbackground.rmi.MapwizServerInterface;
import com.agilent.tntd.lynx.txrx.mixedbackground.rmi.MapwizStructureObserver;
import java.io.IOException;

public class MapwizServerProxy
implements MapwizServerInterface,
CcConnectedComponent,
ApplicationGenericDataReceiver {
    private String variableName = null;
    private ApplicationObject ao = null;
    private MapwizStructureObserver observer = null;

    public MapwizServerProxy(String string, MapwizStructureObserver mapwizStructureObserver) {
        this.variableName = string;
        this.observer = mapwizStructureObserver;
    }

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        switch (errorReporter.getErrorStatus()) {
            case 1: {
                EventLog.instance().log("Could not establish connection to server: " + applicationObject.toString() + " failed to initialise");
                this.ao = null;
                break;
            }
            case 3: {
                EventLog.instance().log("Could not establish connection to server: " + applicationObject.toString() + " requested from unknown domain");
                this.ao = null;
                break;
            }
            case 0: 
            case 2: {
                if (!applicationObject.getName().equals(this.variableName)) break;
                this.ao = applicationObject;
            }
        }
    }

    public void finishInitialise() {
        ApplicationManager.instance().request("ISS", 0, this.variableName, (ApplicationObjectObserver)this);
    }

    public void queryEntireStructure() {
        this.querySegment((short)0, (short)-1);
    }

    public void querySegment(short s, short s2) {
        try {
            ApplicationGenericMetaData applicationGenericMetaData = new ApplicationGenericMetaData();
            PrimitiveTypesWriter primitiveTypesWriter = applicationGenericMetaData.getPrimitiveTypesWriter();
            primitiveTypesWriter.write(s);
            primitiveTypesWriter.write(s2);
            applicationGenericMetaData.completedMetaDataInitialisation();
            this.ao.asyncQuery((ApplicationMetaData)applicationGenericMetaData, (ApplicationObjectObserver)this);
        }
        catch (IOException iOException) {
            EventLog.instance().log("IOException attempting to write to " + this.variableName);
        }
    }

    public void receiveApplicationGenericData(ApplicationGenericData applicationGenericData, ApplicationDataSender applicationDataSender) {
        PrimitiveTypesReader primitiveTypesReader = applicationGenericData.getPrimitiveTypesReader();
        try {
            short s = primitiveTypesReader.readShort();
            short s2 = primitiveTypesReader.readShort();
            short s3 = primitiveTypesReader.readShort();
            short s4 = primitiveTypesReader.readShort();
            short s5 = primitiveTypesReader.readShort();
            short s6 = primitiveTypesReader.readShort();
            short s7 = primitiveTypesReader.readShort();
            short s8 = primitiveTypesReader.readShort();
            short s9 = primitiveTypesReader.readShort();
            short[] sArray = new short[s9];
            int n = 0;
            while (n < s9) {
                sArray[n] = primitiveTypesReader.readShort();
                ++n;
            }
            short[] sArray2 = new short[s9];
            short s10 = 0;
            while (s10 < s9) {
                sArray2[s10] = primitiveTypesReader.readShort();
                ++s10;
            }
            short[] sArray3 = new short[s9];
            short s11 = 0;
            while (s11 < s9) {
                sArray3[s11] = primitiveTypesReader.readShort();
                ++s11;
            }
            short[] sArray4 = new short[s6];
            int n2 = 0;
            while (n2 < s6) {
                sArray4[n2] = primitiveTypesReader.readShort();
                ++n2;
            }
            if (this.observer != null) {
                if (s >= 0) {
                    this.observer.refreshSegment(s, s2, s3, s4, s5, s8, s9, sArray, sArray2, sArray3, s6, s7, sArray4);
                } else {
                    this.observer.handleError(s);
                }
            }
        }
        catch (IOException iOException) {
            EventLog.instance().log("IOException reading from " + this.variableName);
        }
    }

    public void register() {
        this.finishInitialise();
    }

    public void requestSQIRecovery() {
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            simpleTypesWriter.write((short)3);
            ApplicationGenericData applicationGenericData = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
            this.ao.change((ApplicationData)applicationGenericData);
        }
        catch (IOException iOException) {
            EventLog.instance().log("IoException attempting to write to " + this.variableName);
        }
    }

    public boolean setChannel(short s, short s2) {
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            simpleTypesWriter.write((short)0);
            simpleTypesWriter.write(s);
            simpleTypesWriter.write(s2);
            ApplicationGenericData applicationGenericData = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
            return this.ao.change((ApplicationData)applicationGenericData);
        }
        catch (IOException iOException) {
            EventLog.instance().log("IOException attempting to write to " + this.variableName);
            return false;
        }
    }

    public boolean setIdle(short s, int n) {
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            simpleTypesWriter.write((short)1);
            simpleTypesWriter.write(s);
            simpleTypesWriter.write((short)n);
            ApplicationGenericData applicationGenericData = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
            return this.ao.change((ApplicationData)applicationGenericData);
        }
        catch (IOException iOException) {
            EventLog.instance().log("IOException attempting to write to " + this.variableName);
            return false;
        }
    }

    public boolean setSQI(short s, short s2) {
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            simpleTypesWriter.write((short)2);
            simpleTypesWriter.write(s);
            simpleTypesWriter.write(s2);
            ApplicationGenericData applicationGenericData = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
            return this.ao.change((ApplicationData)applicationGenericData);
        }
        catch (IOException iOException) {
            EventLog.instance().log("IOException attempting to write to " + this.variableName);
            return false;
        }
    }

    public boolean setVcat(short s, int n) {
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            simpleTypesWriter.write((short)1);
            simpleTypesWriter.write(s);
            simpleTypesWriter.write((short)n);
            ApplicationGenericData applicationGenericData = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
            return this.ao.change((ApplicationData)applicationGenericData);
        }
        catch (IOException iOException) {
            EventLog.instance().log("IOException attempting to write to " + this.variableName);
            return false;
        }
    }

    public boolean setVcatMultiAu(short s, short s2) {
        try {
            SimpleTypesWriter simpleTypesWriter = new SimpleTypesWriter();
            simpleTypesWriter.initialiseByteArrayToWrite();
            simpleTypesWriter.write((short)4);
            simpleTypesWriter.write(s);
            simpleTypesWriter.write(s2);
            ApplicationGenericData applicationGenericData = new ApplicationGenericData(simpleTypesWriter.getWrittenBytes());
            return this.ao.change((ApplicationData)applicationGenericData);
        }
        catch (IOException iOException) {
            EventLog.instance().log("IOException attempting to write to " + this.variableName);
            return false;
        }
    }

    public void trapTransientError(boolean bl) {
    }

    public void unregister() {
        if (this.ao != null) {
            this.ao.unregister((ApplicationObjectObserver)this);
        }
        this.ao = null;
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            if (applicationData != null) {
                applicationData.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)applicationObject);
            } else {
                this.queryEntireStructure();
            }
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log("ServerConnection cannot receive " + applicationData.toString() + " from " + applicationObject.toString());
        }
    }
}

