/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.bottomlayer.localdomain;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationDomain;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.client.appmodel.ChangeResponseReceiver;
import com.agilent.tntd.eclipse.client.appmodel.OperationFailedException;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;

public abstract class AbstractLocalApplicationObject
implements ApplicationObject {
    private final String name;
    private final ApplicationDomain domain;
    private static final ErrorReporter notNullMetaDataReport = new ErrorReporter(1, "The not null meta data is not supported for the local domain");
    private static final ErrorReporter dataNotInitialisedReport = new ErrorReporter(1, "This data failed to initialise.");
    private static final ErrorReporter unknownStateReport = new ErrorReporter(2, "This data is not yet available.");
    private static final ErrorReporter successReport = new ErrorReporter(0);
    private Object theObservers = null;

    protected AbstractLocalApplicationObject(String string, ApplicationDomain applicationDomain) {
        this.name = string;
        this.domain = applicationDomain;
    }

    public final void asyncQuery(ApplicationMetaData applicationMetaData, ApplicationObjectObserver applicationObjectObserver) {
        EclipseSystem.instance().exitWithError("Async Query is not supported on the " + this.toString());
    }

    public final void asyncUpdate() throws OperationFailedException {
        this.notifyObservers();
    }

    public final void asyncUpdateWithData(ApplicationData applicationData) throws OperationFailedException {
        EclipseSystem.instance().exitWithError("Async update with data is not supported on the " + this.toString());
    }

    protected abstract ApplicationData getData();

    public ApplicationDomain getDomain() {
        return this.domain;
    }

    public abstract int getInitialisationState();

    public final String getName() {
        return this.name;
    }

    private synchronized void notifyObservers() {
        if (this.theObservers != null) {
            if (this.theObservers instanceof ApplicationObjectObserver) {
                ((ApplicationObjectObserver)this.theObservers).update(this.getData(), this);
            } else {
                Iterator iterator = ((HashSet)this.theObservers).iterator();
                while (iterator.hasNext()) {
                    ApplicationObjectObserver applicationObjectObserver = (ApplicationObjectObserver)iterator.next();
                    applicationObjectObserver.update(this.getData(), this);
                }
            }
        }
    }

    protected synchronized void notifyObserversStateChanged(ErrorReporter errorReporter) {
        if (this.theObservers != null) {
            if (this.theObservers instanceof ApplicationObjectObserver) {
                ((ApplicationObjectObserver)this.theObservers).acknowledgeInitialisation(this, errorReporter);
            } else {
                Iterator iterator = ((HashSet)this.theObservers).iterator();
                while (iterator.hasNext()) {
                    ApplicationObjectObserver applicationObjectObserver = (ApplicationObjectObserver)iterator.next();
                    applicationObjectObserver.acknowledgeInitialisation(this, errorReporter);
                }
            }
        }
    }

    public final void processQueryAnswer(ApplicationData applicationData) throws BadApplicationDataReceiverException {
        EclipseSystem.instance().exitWithError("Async Query answer is not supported on the " + this.toString());
    }

    public void register(ApplicationObjectObserver applicationObjectObserver) {
        this.register(applicationObjectObserver, null);
    }

    public void register(ApplicationObjectObserver applicationObjectObserver, ApplicationMetaData applicationMetaData) {
        if (applicationObjectObserver == null) {
            EventLog.instance().log(String.valueOf(this.toString()) + " cannot register a null observer.");
        } else if (applicationMetaData != null) {
            applicationObjectObserver.acknowledgeInitialisation(this, notNullMetaDataReport);
        } else {
            int n = this.getInitialisationState();
            if (n == 1) {
                applicationObjectObserver.acknowledgeInitialisation(this, dataNotInitialisedReport);
            } else {
                this.store(applicationObjectObserver);
                if (n == 2) {
                    applicationObjectObserver.acknowledgeInitialisation(this, successReport);
                    applicationObjectObserver.update(this.getData(), this);
                } else {
                    applicationObjectObserver.acknowledgeInitialisation(this, unknownStateReport);
                }
            }
        }
    }

    private synchronized void remove(ApplicationObjectObserver applicationObjectObserver) {
        if (this.theObservers == applicationObjectObserver) {
            this.theObservers = null;
        } else if (this.theObservers instanceof HashSet) {
            ((HashSet)this.theObservers).remove((Object)applicationObjectObserver);
        }
    }

    private synchronized void store(ApplicationObjectObserver applicationObjectObserver) {
        if (this.theObservers == null) {
            this.theObservers = applicationObjectObserver;
        } else if (this.theObservers instanceof ApplicationObjectObserver) {
            Object object = this.theObservers;
            HashSet hashSet = new HashSet(6);
            this.theObservers = hashSet;
            hashSet.add(object);
            hashSet.add((Object)applicationObjectObserver);
        } else {
            ((HashSet)this.theObservers).add((Object)applicationObjectObserver);
        }
    }

    public abstract String toString();

    public void unregister(ApplicationObjectObserver applicationObjectObserver) {
        this.unregister(applicationObjectObserver, null);
    }

    public void unregister(ApplicationObjectObserver applicationObjectObserver, ApplicationMetaData applicationMetaData) {
        this.remove(applicationObjectObserver);
        if (applicationMetaData != null) {
            EventLog.instance().log("Local domain only supports null meta data.");
        }
    }

    public abstract void asyncChange(ApplicationData var1, ChangeResponseReceiver var2);

    public abstract boolean change(ApplicationData var1);
}

