/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.bottomlayer.localdomain;

import com.agilent.tntd.eclipse.bottomlayer.localdomain.ErrorApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationDomain;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.client.appmodel.RegistrableData;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.UnsupportedOperationException;

public class LocalDomain
implements ApplicationDomain {
    private final String myName;
    private Map theNameToApplicationObjectMap = Collections.synchronizedMap((Map)new HashMap());
    private final ErrorReporter noApplicationObjectReport = new ErrorReporter(1);
    private final ErrorApplicationObject errorAO = new ErrorApplicationObject(this);

    public LocalDomain(String string) {
        this.myName = string;
    }

    public void disconnectDependencies() {
        this.theNameToApplicationObjectMap.clear();
        this.theNameToApplicationObjectMap = null;
    }

    public final String getName() {
        return this.myName;
    }

    public boolean loadData(String string, RegistrableData registrableData) {
        if (this.theNameToApplicationObjectMap.containsKey((Object)string)) {
            return false;
        }
        ApplicationObject applicationObject = registrableData.createApplicationObject(this, string);
        if (applicationObject != null) {
            this.register(applicationObject);
            return true;
        }
        throw new UnsupportedOperationException(String.valueOf(this.toString()) + " doesn't allow to load data which doesn't create its own application object.");
    }

    public void register(ApplicationObject applicationObject) {
        this.theNameToApplicationObjectMap.put((Object)applicationObject.getName(), (Object)applicationObject);
    }

    public void request(String string, int n, ApplicationObjectObserver applicationObjectObserver, ApplicationMetaData applicationMetaData) {
        ApplicationObject applicationObject = (ApplicationObject)this.theNameToApplicationObjectMap.get((Object)string);
        if (applicationObject != null) {
            applicationObject.register(applicationObjectObserver, applicationMetaData);
        } else {
            this.noApplicationObjectReport.setTheDescription("The Local Domain:" + this.getName() + " doesn't know the variable " + string);
            this.errorAO.setName(string);
            applicationObjectObserver.acknowledgeInitialisation(this.errorAO, this.noApplicationObjectReport);
        }
    }

    public String toString() {
        return "LocalDomain[" + this.getName() + "]";
    }

    public boolean unloadData(String string) {
        return this.theNameToApplicationObjectMap.remove((Object)string) != null;
    }

    public void unregister(ApplicationObject applicationObject) {
        this.theNameToApplicationObjectMap.remove((Object)applicationObject.getName());
    }
}

