/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.bottomlayer.localdomain;

import com.agilent.tntd.eclipse.bottomlayer.localdomain.ChangeableApplicationData;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.client.appmodel.OperationFailedException;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;

class LocalIntegerRemoteMasksData
extends ChangeableApplicationData
implements ApplicationObjectObserver,
MaskedIntegerDataReceiver {
    private ApplicationObject theApplicationObject;
    private MaskedIntegerValue theData;
    private ApplicationObject theMasksApplictionObject = null;
    private MaskedIntegerValue previousValue = null;

    public void acknowledgeInitialisation(ApplicationObject applicationObject, ErrorReporter errorReporter) {
        if (errorReporter.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + applicationObject.toString() + " failed to initialise.");
        } else if (errorReporter.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
        } else {
            this.theMasksApplictionObject = applicationObject;
        }
    }

    public boolean change(ApplicationData applicationData) {
        boolean bl = false;
        if (this.theData != null && applicationData instanceof MaskedIntegerValue) {
            MaskedIntegerValue maskedIntegerValue = (MaskedIntegerValue)applicationData;
            if (this.theData.getValue() != maskedIntegerValue.getValue()) {
                if (this.theData.getOptionMask().query(maskedIntegerValue.getValue()) && this.theData.getStateMask().query(maskedIntegerValue.getValue())) {
                    this.theData = new MaskedIntegerValue(maskedIntegerValue.getValue(), this.previousValue);
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public int getInitialisationState() {
        int n;
        int n2 = n = this.theMasksApplictionObject == null ? 1 : this.theMasksApplictionObject.getInitialisationState();
        if (n == 2) {
            n = this.theData == null ? 0 : 2;
        }
        return n;
    }

    public void initialise(ApplicationObject applicationObject, String string, String string2) {
        this.theApplicationObject = applicationObject;
        if (applicationObject != null) {
            ApplicationManager.instance().request(string2, 0, string, (ApplicationObjectObserver)this);
        }
    }

    private void permanentError() {
        if (this.theMasksApplictionObject != null) {
            this.theMasksApplictionObject.unregister(this);
            this.theMasksApplictionObject = null;
        }
    }

    public void receivedBy(ApplicationDataReceiver applicationDataReceiver, ApplicationDataSender applicationDataSender) throws BadApplicationDataReceiverException {
        this.theData.receivedBy(applicationDataReceiver, applicationDataSender);
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue maskedIntegerValue, ApplicationDataSender applicationDataSender) {
        if (applicationDataSender == this.theMasksApplictionObject) {
            if (maskedIntegerValue.hasDifferentMasks(this.previousValue)) {
                this.theData = this.previousValue = maskedIntegerValue;
                try {
                    this.theApplicationObject.asyncUpdate();
                }
                catch (OperationFailedException operationFailedException) {}
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + applicationDataSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public String toString() {
        return "Data for " + this.theApplicationObject;
    }

    public void update(ApplicationData applicationData, ApplicationObject applicationObject) {
        try {
            applicationData.receivedBy(this, applicationObject);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + applicationData.toString() + " from " + applicationObject.toString());
            this.permanentError();
        }
    }

    LocalIntegerRemoteMasksData() {
    }
}

