/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.bottomlayer.localdomain;

import com.agilent.tntd.eclipse.bottomlayer.localdomain.ChangeableApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;

class LocalMaskedIntegerData
extends ChangeableApplicationData {
    private MaskedIntegerValue theData;
    private int maxValue = 0;

    public boolean change(ApplicationData applicationData) {
        boolean bl = false;
        if (this.theData != null && applicationData instanceof MaskedIntegerValue) {
            MaskedIntegerValue maskedIntegerValue = (MaskedIntegerValue)applicationData;
            if (this.theData.getValue() != maskedIntegerValue.getValue() && maskedIntegerValue.getValue() < this.maxValue) {
                this.theData = new MaskedIntegerValue(maskedIntegerValue.getValue(), this.theData);
                bl = true;
            }
        }
        return bl;
    }

    public int getInitialisationState() {
        return this.theData == null ? 1 : 2;
    }

    public void initialise(int n, int n2) {
        boolean bl;
        this.maxValue = n2;
        boolean bl2 = bl = n2 < 64 && -1 < n && n < 64;
        if (bl) {
            long l = new Double(Math.pow(2.0, n2)).longValue() - 1L;
            this.theData = new MaskedIntegerValue(n, l, l);
        }
    }

    public void receivedBy(ApplicationDataReceiver applicationDataReceiver, ApplicationDataSender applicationDataSender) throws BadApplicationDataReceiverException {
        this.theData.receivedBy(applicationDataReceiver, applicationDataSender);
    }

    LocalMaskedIntegerData() {
    }
}

