/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.client.appmodel;

import com.agilent.tntd.eclipse.bottomlayer.compositedata.CompositeDataReader;
import com.agilent.tntd.eclipse.bottomlayer.domains.DomainsNames;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationDomain;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.client.appmodel.RegistrableData;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.SingletonRegistry;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;

public class ApplicationManager {
    private static ApplicationManager theApplicationManager;
    private ArrayList domains;
    private HashMap compositeDataReaderMap = new HashMap();

    private ApplicationManager() {
        this.domains = new ArrayList(1);
    }

    public synchronized void add(ApplicationDomain applicationDomain) {
        this.domains.add((Object)applicationDomain);
    }

    public CompositeDataReader getCompositeDataReader(ApplicationDomain applicationDomain, String string) {
        return (CompositeDataReader)this.compositeDataReaderMap.get((Object)string);
    }

    public static synchronized ApplicationManager instance() {
        if (theApplicationManager == null) {
            theApplicationManager = new ApplicationManager();
            SingletonRegistry.instance().add(theApplicationManager);
        }
        return theApplicationManager;
    }

    public boolean loadDataForDomain(int n, String string, RegistrableData registrableData) {
        if (n >= 0 && n <= DomainsNames.theDomainsID.length) {
            return this.loadDataForDomain(DomainsNames.theDomainsID[n][1], string, registrableData);
        }
        return false;
    }

    public boolean loadDataForDomain(String string, String string2, RegistrableData registrableData) {
        if (string != null && string2.length() != 0) {
            int n = 0;
            while (n < this.domains.size()) {
                ApplicationDomain applicationDomain = (ApplicationDomain)this.domains.get(n);
                if (applicationDomain.getName().equals(string)) {
                    return applicationDomain.loadData(string2, registrableData);
                }
                ++n;
            }
        }
        return false;
    }

    public synchronized void registerCompositeDataReader(ApplicationDomain applicationDomain, String string, CompositeDataReader compositeDataReader) {
        this.compositeDataReaderMap.put((Object)string, (Object)compositeDataReader);
    }

    private void remove(ApplicationDomain applicationDomain) {
        this.domains.remove((Object)applicationDomain);
    }

    public synchronized void removeAllDomains() {
        int n = 0;
        while (n < this.domains.size()) {
            ApplicationDomain applicationDomain = (ApplicationDomain)this.domains.get(n);
            this.remove(applicationDomain);
            applicationDomain.disconnectDependencies();
            ++n;
        }
    }

    public void request(int n, int n2, String string, ApplicationObjectObserver applicationObjectObserver) {
        this.request(n, n2, string, applicationObjectObserver, null);
    }

    public void request(int n, int n2, String string, ApplicationObjectObserver applicationObjectObserver, ApplicationMetaData applicationMetaData) {
        if (n >= 0 && n <= DomainsNames.theDomainsID.length) {
            this.request(DomainsNames.theDomainsID[n][1], n2, string, applicationObjectObserver, applicationMetaData);
        } else if (applicationObjectObserver != null) {
            applicationObjectObserver.acknowledgeInitialisation(null, new ErrorReporter(3));
        }
    }

    public void request(String string, int n, String string2, ApplicationObjectObserver applicationObjectObserver) {
        this.request(string, n, string2, applicationObjectObserver, null);
    }

    public void request(String string, int n, String string2, ApplicationObjectObserver applicationObjectObserver, ApplicationMetaData applicationMetaData) {
        if (string != null && string2.length() != 0) {
            int n2 = 0;
            while (n2 < this.domains.size()) {
                ApplicationDomain applicationDomain = (ApplicationDomain)this.domains.get(n2);
                if (applicationDomain.getName().equals(string)) {
                    applicationDomain.request(string2, n, applicationObjectObserver, applicationMetaData);
                    return;
                }
                ++n2;
            }
        }
        if (applicationObjectObserver != null) {
            applicationObjectObserver.acknowledgeInitialisation(null, new ErrorReporter(3));
        }
    }

    public boolean unloadDataForDomain(int n, String string) {
        if (n >= 0 && n <= DomainsNames.theDomainsID.length) {
            return this.unloadDataForDomain(DomainsNames.theDomainsID[n][1], string);
        }
        return false;
    }

    public boolean unloadDataForDomain(String string, String string2) {
        if (string != null && string2.length() != 0) {
            int n = 0;
            while (n < this.domains.size()) {
                ApplicationDomain applicationDomain = (ApplicationDomain)this.domains.get(n);
                if (applicationDomain.getName().equals(string)) {
                    return applicationDomain.unloadData(string2);
                }
                ++n;
            }
        }
        return false;
    }
}

