/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.client.appmodel;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationDomain;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.client.appmodel.GenericApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.OperationFailedException;
import com.agilent.tntd.eclipse.client.appmodel.RegistrableData;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.UnsupportedOperationException;

public abstract class GenericApplicationDomain
implements ApplicationDomain {
    private final String myName;
    private Map theNameToApplicationObjectMap = new HashMap(507, 0.5f);
    private Set[] thePrioritisedSet = new HashSet[]{new HashSet(251), new HashSet(251), new HashSet(15)};
    private Object dataLock = new Object();

    public GenericApplicationDomain(String string) {
        this.myName = string;
    }

    protected abstract GenericApplicationObject createApplicationObject(String var1);

    public void disconnectDependencies() {
        Object object = this.getDataLock();
        synchronized (object) {
            this.theNameToApplicationObjectMap = null;
            this.thePrioritisedSet = null;
        }
    }

    protected Object getDataLock() {
        return this.dataLock;
    }

    public final String getName() {
        return this.myName;
    }

    public boolean loadData(String string, RegistrableData registrableData) {
        throw new UnsupportedOperationException(String.valueOf(this.toString()) + " doesn't allow user to load its own data.");
    }

    public GenericApplicationObject request(String string) {
        Object object = this.getDataLock();
        synchronized (object) {
            GenericApplicationObject genericApplicationObject = (GenericApplicationObject)this.theNameToApplicationObjectMap.get((Object)string);
            if (genericApplicationObject == null) {
                genericApplicationObject = this.createApplicationObject(string);
                this.theNameToApplicationObjectMap.put((Object)string, (Object)genericApplicationObject);
            }
            return genericApplicationObject;
        }
    }

    public GenericApplicationObject request(String string, int n) {
        Object object = this.getDataLock();
        synchronized (object) {
            GenericApplicationObject genericApplicationObject = this.request(string);
            if (n > this.thePrioritisedSet.length - 1) {
                HashSet[] hashSetArray = new HashSet[n + 1];
                int n2 = 0;
                while (n2 < this.thePrioritisedSet.length) {
                    hashSetArray[n2] = this.thePrioritisedSet[n2];
                    ++n2;
                }
                hashSetArray[n] = new HashSet(251);
                this.thePrioritisedSet = hashSetArray;
                EventLog.instance().log("GenericApplicationDomain need to increase PrioritisedSet size to " + (n + 1));
            }
            this.storeApplicationObjectAtNewPriority(genericApplicationObject, n);
            return genericApplicationObject;
        }
    }

    private void storeApplicationObjectAtNewPriority(GenericApplicationObject genericApplicationObject, int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.thePrioritisedSet.length) {
            Set set = this.thePrioritisedSet[n2];
            if (set != null && set.contains((Object)genericApplicationObject)) {
                bl = true;
                if (n2 < n) {
                    set.remove((Object)genericApplicationObject);
                    this.thePrioritisedSet[n].add((Object)genericApplicationObject);
                }
                return;
            }
            ++n2;
        }
        if (!bl) {
            this.thePrioritisedSet[n].add((Object)genericApplicationObject);
        }
    }

    public boolean unloadData(String string) {
        throw new UnsupportedOperationException(String.valueOf(this.toString()) + " doesn't allow user to unload data.");
    }

    public void unregister(ApplicationObject applicationObject) {
        Object object = this.getDataLock();
        synchronized (object) {
            this.theNameToApplicationObjectMap.remove((Object)applicationObject.getName());
            int n = 0;
            while (n < this.thePrioritisedSet.length) {
                Set set = this.thePrioritisedSet[n];
                if (set != null && set.contains((Object)applicationObject)) {
                    set.remove((Object)applicationObject);
                    return;
                }
                ++n;
            }
        }
    }

    public void unregister(GenericApplicationObject genericApplicationObject) {
        this.unregister((ApplicationObject)genericApplicationObject);
    }

    protected void updateAll() {
        Object object = this.getDataLock();
        synchronized (object) {
            int n = 0;
            while (n < this.thePrioritisedSet.length) {
                if (this.thePrioritisedSet[n] != null) {
                    Iterator iterator = this.thePrioritisedSet[n].iterator();
                    while (iterator.hasNext()) {
                        try {
                            ((ApplicationObject)iterator.next()).asyncUpdate();
                        }
                        catch (OperationFailedException operationFailedException) {}
                    }
                }
                ++n;
            }
        }
    }

    public abstract void request(String var1, int var2, ApplicationObjectObserver var3, ApplicationMetaData var4);

    public abstract void register(ApplicationObject var1);
}

