/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.client.appmodel;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.client.appmodel.GenericApplicationDomain;
import com.agilent.tntd.eclipse.client.appmodel.GenericApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.GenericApplicationObjectState;
import com.agilent.tntd.eclipse.client.appmodel.OperationFailedException;
import com.agilent.tntd.eclipse.client.appmodel.RawDataAccess;
import com.agilent.tntd.eclipse.client.appmodel.RawDataApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.applicationobjectstate.NoRawDataIDState;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.RawDataID;
import com.agilent.tntd.eclipse.common.util.EventLog;
import java.util.Hashtable;

public class RawDataApplicationDomain
extends GenericApplicationDomain {
    protected RawDataAccess accessor;
    private Hashtable theIDtoApplicationObjectTable = new Hashtable(251);

    public RawDataApplicationDomain(String string, RawDataAccess rawDataAccess) {
        super(string);
        this.accessor = rawDataAccess;
    }

    protected GenericApplicationObject createApplicationObject(String string) {
        return new RawDataApplicationObject(string, this);
    }

    protected GenericApplicationObjectState createApplicationObjectStateForID(RawDataID rawDataID, String string) {
        EventLog.instance().log(String.valueOf(this.toString()) + " doesn't support this type of id " + rawDataID.toString());
        return null;
    }

    public void disconnectDependencies() {
        Object object = this.getDataLock();
        synchronized (object) {
            this.accessor.disconnectFromDomain();
            this.accessor = null;
            this.theIDtoApplicationObjectTable = null;
            super.disconnectDependencies();
        }
    }

    private RawDataApplicationObject findProxyFromID(RawDataID rawDataID) {
        return (RawDataApplicationObject)this.theIDtoApplicationObjectTable.get(rawDataID);
    }

    public RawDataAccess getRawDataAccess() {
        return this.accessor;
    }

    public final void notifyIDforName(String string, RawDataID rawDataID) {
        Object object = this.getDataLock();
        synchronized (object) {
            RawDataApplicationObject rawDataApplicationObject = (RawDataApplicationObject)this.request(string);
            if (rawDataID == null) {
                this.unregister(rawDataApplicationObject);
                rawDataApplicationObject.changeState(new NoRawDataIDState());
            } else {
                rawDataApplicationObject.setID(rawDataID);
                GenericApplicationObjectState genericApplicationObjectState = this.createApplicationObjectStateForID(rawDataID, string);
                if (genericApplicationObjectState != null) {
                    this.register(rawDataApplicationObject);
                    rawDataApplicationObject.changeState(genericApplicationObjectState);
                } else {
                    rawDataApplicationObject.changeState(new NoRawDataIDState());
                }
                this.theIDtoApplicationObjectTable.put(rawDataID, rawDataApplicationObject);
            }
        }
    }

    public void register(ApplicationObject applicationObject) {
        EventLog.instance().log("The domain " + this.toString() + " doesn't know how to register this Application object " + applicationObject.toString());
    }

    public void register(RawDataApplicationObject rawDataApplicationObject) {
        EventLog.instance().log("The domain " + this.toString() + " doesn't know how to register this Application object " + rawDataApplicationObject.toString());
    }

    public final void request(String string, int n, ApplicationObjectObserver applicationObjectObserver, ApplicationMetaData applicationMetaData) {
        Object object = this.getDataLock();
        synchronized (object) {
            if (string == "BEGIN" || string == "END") {
                try {
                    this.accessor.asyncRequestObjectID(string);
                }
                catch (OperationFailedException operationFailedException) {
                    System.out.println("Cannot request object ID for one of the tags of the queue");
                    System.exit(1);
                }
            } else {
                GenericApplicationObject genericApplicationObject = this.request(string, n);
                genericApplicationObject.register(applicationObjectObserver, applicationMetaData);
            }
        }
    }

    public void unregister(RawDataApplicationObject rawDataApplicationObject) {
        EventLog.instance().log("The domain " + this.toString() + " doesn't know how to unregister this Application object " + rawDataApplicationObject.toString());
    }

    public final void updateSingleID(RawDataID rawDataID, ApplicationData applicationData) {
        Object object = this.getDataLock();
        synchronized (object) {
            RawDataApplicationObject rawDataApplicationObject = this.findProxyFromID(rawDataID);
            if (rawDataApplicationObject != null) {
                try {
                    rawDataApplicationObject.asyncUpdateWithData(applicationData);
                }
                catch (OperationFailedException operationFailedException) {}
            }
        }
    }

    public final void updateValueForID(RawDataID rawDataID, ApplicationData applicationData) {
        Object object = this.getDataLock();
        synchronized (object) {
            RawDataApplicationObject rawDataApplicationObject = this.findProxyFromID(rawDataID);
            if (rawDataApplicationObject != null) {
                try {
                    rawDataApplicationObject.processQueryAnswer(applicationData);
                }
                catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {}
            }
        }
    }
}

