/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.client.appmodel;

import com.agilent.tntd.eclipse.client.appmodel.GenericApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.OperationFailedException;
import com.agilent.tntd.eclipse.client.appmodel.RawDataApplicationDomain;
import com.agilent.tntd.eclipse.client.appmodel.applicationobjectstate.WaitForInitialisation;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.RawDataID;

public class RawDataApplicationObject
extends GenericApplicationObject {
    protected RawDataID id;

    public RawDataApplicationObject(String string, RawDataApplicationDomain rawDataApplicationDomain) {
        super(string, rawDataApplicationDomain);
        this.changeState(new WaitForInitialisation());
        try {
            rawDataApplicationDomain.getRawDataAccess().asyncRequestObjectID(string);
        }
        catch (OperationFailedException operationFailedException) {}
    }

    public final RawDataID getID() {
        return this.id;
    }

    private RawDataApplicationDomain getRawDataDomain() {
        return (RawDataApplicationDomain)this.getDomain();
    }

    public final void processAsyncQuery(ApplicationMetaData applicationMetaData) {
        try {
            this.getRawDataDomain().getRawDataAccess().asyncQuery(this.id, applicationMetaData);
        }
        catch (OperationFailedException operationFailedException) {}
    }

    public final boolean processChange(ApplicationData applicationData) {
        boolean bl = false;
        try {
            bl = this.getRawDataDomain().getRawDataAccess().change(this.id, applicationData);
        }
        catch (OperationFailedException operationFailedException) {}
        return bl;
    }

    public void sendEvent(ApplicationData applicationData) {
        try {
            this.getRawDataDomain().getRawDataAccess().sendEvent(this.getID(), applicationData);
        }
        catch (OperationFailedException operationFailedException) {}
    }

    public final void setID(RawDataID rawDataID) {
        this.id = rawDataID;
    }

    public String toString() {
        return "RawDataApplicationObject[" + this.getName() + "] from " + this.getDomain().toString();
    }
}

