/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.common.util;

import com.agilent.tntd.eclipse.common.util.SingletonRegistry;
import java.util.Vector;

public class EventLog {
    private static EventLog theInstance = null;
    private Vector log = new Vector();
    private int maxSize = -1;
    private boolean displayImmediately = false;

    private EventLog() {
    }

    public String getEvent(int n) {
        return (String)this.log.elementAt(n);
    }

    public int getSize() {
        return this.log.size();
    }

    public static synchronized EventLog instance() {
        if (theInstance == null) {
            theInstance = new EventLog();
            SingletonRegistry.instance().add(theInstance);
        }
        return theInstance;
    }

    private boolean isDisplayImmediately() {
        return this.displayImmediately;
    }

    public void log(String string) {
        if (string == null || string.length() == 0) {
            string = "Some object attempted to log a 'null' or an empty message";
        }
        if (this.isDisplayImmediately() || this.maxSize == -1) {
            System.out.println(string);
        } else {
            this.log.addElement(string);
            if (this.log.size() > this.maxSize) {
                this.log.removeElementAt(0);
            }
        }
    }

    public void setDisplayImmediately(boolean bl) {
        this.displayImmediately = bl;
    }

    public void setMaximumSize(int n) {
        this.maxSize = n;
        if (this.maxSize != -1) {
            while (this.log.size() > this.maxSize) {
                this.log.removeElementAt(0);
            }
        }
    }
}

